/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.client.endpoint;

import io.opentelemetry.testing.internal.armeria.client.ClientRequestContext;
import io.opentelemetry.testing.internal.armeria.client.Endpoint;
import io.opentelemetry.testing.internal.armeria.client.endpoint.DefaultEndpointSelector;
import io.opentelemetry.testing.internal.armeria.client.endpoint.EndpointGroup;
import io.opentelemetry.testing.internal.armeria.client.endpoint.EndpointSelectionStrategy;
import io.opentelemetry.testing.internal.armeria.client.endpoint.EndpointSelector;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.loadbalancer.LoadBalancer;
import io.opentelemetry.testing.internal.armeria.common.loadbalancer.RampingUpLoadBalancerBuilder;
import io.opentelemetry.testing.internal.armeria.common.loadbalancer.UpdatableLoadBalancer;
import io.opentelemetry.testing.internal.armeria.common.loadbalancer.WeightTransition;
import io.opentelemetry.testing.internal.armeria.common.util.Ticker;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.Preconditions;
import io.opentelemetry.testing.internal.io.netty.util.concurrent.EventExecutor;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;

final class WeightRampingUpStrategy
implements DefaultEndpointSelector.LoadBalancerFactory<LoadBalancer<Endpoint, ClientRequestContext>>,
EndpointSelectionStrategy {
    static final EndpointSelectionStrategy INSTANCE = EndpointSelectionStrategy.builderForRampingUp().build();
    private final WeightTransition<Endpoint> weightTransition;
    private final Supplier<EventExecutor> executorSupplier;
    private final long rampingUpIntervalMillis;
    private final int totalSteps;
    private final long rampingUpTaskWindowMillis;
    private final Ticker ticker;
    private final Function<Endpoint, Long> timestampFunction;

    WeightRampingUpStrategy(WeightTransition<Endpoint> weightTransition, Supplier<EventExecutor> executorSupplier, long rampingUpIntervalMillis, int totalSteps, long rampingUpTaskWindowMillis, Function<Endpoint, Long> timestampFunction, Ticker ticker) {
        this.weightTransition = Objects.requireNonNull(weightTransition, "weightTransition");
        this.executorSupplier = Objects.requireNonNull(executorSupplier, "executorSupplier");
        Preconditions.checkArgument(rampingUpIntervalMillis > 0L, "rampingUpIntervalMillis: %s (expected: > 0)", rampingUpIntervalMillis);
        this.rampingUpIntervalMillis = rampingUpIntervalMillis;
        Preconditions.checkArgument(totalSteps > 0, "totalSteps: %s (expected: > 0)", totalSteps);
        this.totalSteps = totalSteps;
        Preconditions.checkArgument(rampingUpTaskWindowMillis >= 0L, "rampingUpTaskWindowMillis: %s (expected: > 0)", rampingUpTaskWindowMillis);
        this.rampingUpTaskWindowMillis = rampingUpTaskWindowMillis;
        this.timestampFunction = timestampFunction;
        this.ticker = Objects.requireNonNull(ticker, "ticker");
    }

    @Override
    public EndpointSelector newSelector(EndpointGroup endpointGroup) {
        return new DefaultEndpointSelector<LoadBalancer<Endpoint, ClientRequestContext>>(endpointGroup, this);
    }

    @Override
    public LoadBalancer<Endpoint, ClientRequestContext> newLoadBalancer(@Nullable LoadBalancer<Endpoint, ClientRequestContext> oldLoadBalancer, List<Endpoint> candidates) {
        if (oldLoadBalancer == null) {
            UpdatableLoadBalancer<Endpoint> newLoadBalancer = ((RampingUpLoadBalancerBuilder)((RampingUpLoadBalancerBuilder)((RampingUpLoadBalancerBuilder)((RampingUpLoadBalancerBuilder)((RampingUpLoadBalancerBuilder)((RampingUpLoadBalancerBuilder)((RampingUpLoadBalancerBuilder)LoadBalancer.builderForRampingUp(candidates).rampingUpIntervalMillis(this.rampingUpIntervalMillis)).rampingUpTaskWindowMillis(this.rampingUpTaskWindowMillis)).totalSteps(this.totalSteps)).weightTransition(this.weightTransition)).timestampFunction(this.timestampFunction)).executor(this.executorSupplier.get())).ticker(this.ticker)).build();
            return (LoadBalancer)this.unsafeCast(newLoadBalancer);
        }
        assert (oldLoadBalancer instanceof UpdatableLoadBalancer);
        UpdatableLoadBalancer casted = (UpdatableLoadBalancer)oldLoadBalancer;
        casted.updateCandidates(candidates);
        return (LoadBalancer)this.unsafeCast(casted);
    }
}

