/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.client.endpoint;

import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class EndpointGroupUtil {
    private static final String ENDPOINT_GROUP_MARK = "group:";
    private static final Pattern ENDPOINT_GROUP_PATTERN = Pattern.compile("://(?:[^@]*@)?(group:([^:/]+)(:\\d+)?)");

    @Nullable
    static String getEndpointGroupName(String uri) {
        Matcher matcher = ENDPOINT_GROUP_PATTERN.matcher(uri);
        if (matcher.find()) {
            return matcher.group(2);
        }
        return null;
    }

    static String replaceEndpointGroup(String uri, String endpointUri) {
        Matcher matcher = ENDPOINT_GROUP_PATTERN.matcher(uri);
        if (matcher.find()) {
            return new StringBuilder(uri).replace(matcher.start(1), matcher.end(1), endpointUri).toString();
        }
        return uri;
    }

    private EndpointGroupUtil() {
    }
}

