/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.client.endpoint;

import io.opentelemetry.testing.internal.armeria.client.ClientRequestContext;
import io.opentelemetry.testing.internal.armeria.client.Endpoint;
import io.opentelemetry.testing.internal.armeria.client.endpoint.EndpointGroup;
import io.opentelemetry.testing.internal.armeria.client.endpoint.EndpointSelectionTimeoutException;
import io.opentelemetry.testing.internal.armeria.client.endpoint.EndpointSelector;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.annotation.UnstableApi;
import io.opentelemetry.testing.internal.armeria.internal.client.AbstractAsyncSelector;
import io.opentelemetry.testing.internal.armeria.internal.client.ClientPendingThrowableUtil;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;

public abstract class AbstractEndpointSelector
implements EndpointSelector {
    private final EndpointGroup endpointGroup;
    private final EndpointAsyncSelector asyncSelector;

    protected AbstractEndpointSelector(EndpointGroup endpointGroup) {
        this.endpointGroup = Objects.requireNonNull(endpointGroup, "endpointGroup");
        this.asyncSelector = new EndpointAsyncSelector(endpointGroup);
    }

    protected final EndpointGroup group() {
        return this.endpointGroup;
    }

    @UnstableApi
    protected final void initialize() {
        this.endpointGroup.addListener(this::refreshEndpoints, true);
    }

    @Override
    public CompletableFuture<Endpoint> select(ClientRequestContext ctx, ScheduledExecutorService executor, long timeoutMillis) {
        return this.asyncSelector.select(ctx, executor, this.endpointGroup.selectionTimeoutMillis());
    }

    private void refreshEndpoints(List<Endpoint> endpoints) {
        this.updateNewEndpoints(endpoints);
        this.asyncSelector.refresh();
    }

    Set<? extends CompletableFuture<Endpoint>> pendingFutures() {
        return this.asyncSelector.pendingFutures();
    }

    @UnstableApi
    protected void updateNewEndpoints(List<Endpoint> endpoints) {
    }

    private class EndpointAsyncSelector
    extends AbstractAsyncSelector<Endpoint> {
        private final EndpointGroup endpointGroup;

        EndpointAsyncSelector(EndpointGroup endpointGroup) {
            this.endpointGroup = endpointGroup;
        }

        @Override
        protected void onTimeout(ClientRequestContext ctx, long selectionTimeoutMillis) {
            EndpointSelectionTimeoutException ex = EndpointSelectionTimeoutException.get(this.endpointGroup, selectionTimeoutMillis);
            ClientPendingThrowableUtil.setPendingThrowable(ctx, ex);
        }

        @Override
        @Nullable
        protected Endpoint selectNow(ClientRequestContext ctx) {
            return AbstractEndpointSelector.this.selectNow(ctx);
        }

        @Override
        protected Set<? extends CompletableFuture<Endpoint>> pendingFutures() {
            return super.pendingFutures();
        }
    }
}

