/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.client.circuitbreaker;

import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.Preconditions;

@Deprecated
public final class EventCount {
    public static final EventCount ZERO = new EventCount(0L, 0L);
    private final long success;
    private final long failure;

    public static EventCount of(long success, long failure) {
        if (success == 0L && failure == 0L) {
            return ZERO;
        }
        return new EventCount(success, failure);
    }

    private EventCount(long success, long failure) {
        Preconditions.checkArgument(success >= 0L, "success: %s (expected: >= 0)", success);
        Preconditions.checkArgument(failure >= 0L, "failure: %s (expected: >= 0)", failure);
        this.success = success;
        this.failure = failure;
    }

    public long success() {
        return this.success;
    }

    public long failure() {
        return this.failure;
    }

    public long total() {
        return this.success + this.failure;
    }

    public double successRate() {
        long total = this.total();
        if (total == 0L) {
            throw new ArithmeticException("Failed to calculate success rate since total count is 0");
        }
        return (double)this.success / (double)total;
    }

    public double failureRate() {
        long total = this.total();
        if (total == 0L) {
            throw new ArithmeticException("Failed to calculate failure rate since total count is 0");
        }
        return (double)this.failure / (double)total;
    }

    public int hashCode() {
        return (int)(31L * this.success + this.failure);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EventCount)) {
            return false;
        }
        EventCount that = (EventCount)o;
        return this.success == that.success && this.failure == that.failure;
    }

    public String toString() {
        long total = this.total();
        if (total == 0L) {
            return "success% = NaN (0/0)";
        }
        double percentageOfSuccess = 100.0 * this.successRate();
        return String.format("success%% = %.2f%% (%d/%d)", percentageOfSuccess, this.success(), total);
    }
}

