/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.client.circuitbreaker;

import io.opentelemetry.testing.internal.armeria.client.AbstractRuleWithContentBuilder;
import io.opentelemetry.testing.internal.armeria.client.ClientRequestContext;
import io.opentelemetry.testing.internal.armeria.client.circuitbreaker.CircuitBreakerDecision;
import io.opentelemetry.testing.internal.armeria.client.circuitbreaker.CircuitBreakerRule;
import io.opentelemetry.testing.internal.armeria.client.circuitbreaker.CircuitBreakerRuleBuilder;
import io.opentelemetry.testing.internal.armeria.client.circuitbreaker.CircuitBreakerRuleUtil;
import io.opentelemetry.testing.internal.armeria.client.circuitbreaker.CircuitBreakerRuleWithContent;
import io.opentelemetry.testing.internal.armeria.common.RequestHeaders;
import io.opentelemetry.testing.internal.armeria.common.Response;
import io.opentelemetry.testing.internal.armeria.internal.client.RuleFilter;
import java.util.concurrent.CompletionStage;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;

public final class CircuitBreakerRuleWithContentBuilder<T extends Response>
extends AbstractRuleWithContentBuilder<CircuitBreakerRuleWithContentBuilder<T>, T> {
    CircuitBreakerRuleWithContentBuilder(BiPredicate<? super ClientRequestContext, ? super RequestHeaders> requestHeadersFilter) {
        super(requestHeadersFilter);
    }

    public CircuitBreakerRuleWithContent<T> thenSuccess() {
        return this.build(CircuitBreakerDecision.success());
    }

    public CircuitBreakerRuleWithContent<T> thenFailure() {
        return this.build(CircuitBreakerDecision.failure());
    }

    public CircuitBreakerRuleWithContent<T> thenIgnore() {
        return this.build(CircuitBreakerDecision.ignore());
    }

    private CircuitBreakerRuleWithContent<T> build(CircuitBreakerDecision decision) {
        BiFunction responseFilter = this.responseFilter();
        boolean hasResponseFilter = responseFilter != null;
        RuleFilter ruleFilter = RuleFilter.of(this.requestHeadersFilter(), this.responseHeadersFilter(), this.responseTrailersFilter(), this.grpcTrailersFilter(), this.exceptionFilter(), this.totalDurationFilter(), hasResponseFilter);
        CircuitBreakerRule first = CircuitBreakerRuleBuilder.build(ruleFilter, decision, this.requiresResponseTrailers());
        if (!hasResponseFilter) {
            return CircuitBreakerRuleUtil.fromCircuitBreakerRule(first);
        }
        CircuitBreakerRuleWithContent<Response> second = (ctx, content, cause) -> {
            if (content == null) {
                return CircuitBreakerRuleUtil.NEXT_DECISION;
            }
            assert (responseFilter != null);
            return ((CompletionStage)responseFilter.apply(ctx, content)).handle((matched, cause0) -> {
                if (cause0 != null) {
                    return CircuitBreakerDecision.next();
                }
                return matched != false ? decision : CircuitBreakerDecision.next();
            });
        };
        return CircuitBreakerRuleUtil.orElse(first, second);
    }
}

