/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.client.circuitbreaker;

import io.opentelemetry.testing.internal.armeria.client.circuitbreaker.CircuitState;
import io.opentelemetry.testing.internal.armeria.common.metric.MeterIdPrefix;
import io.opentelemetry.testing.internal.armeria.common.util.EventCount;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.util.concurrent.AtomicDouble;
import io.opentelemetry.testing.internal.io.micrometer.core.instrument.Counter;
import io.opentelemetry.testing.internal.io.micrometer.core.instrument.MeterRegistry;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;

final class CircuitBreakerMetrics {
    private final AtomicReference<EventCount> latestEventCount = new AtomicReference<EventCount>(EventCount.ZERO);
    private final AtomicDouble state = new AtomicDouble(1.0);
    private final Counter transitionsToClosed;
    private final Counter transitionsToOpen;
    private final Counter transitionsToHalfOpen;
    private final Counter transitionsToForcedOpen;
    private final Counter rejectedRequests;

    CircuitBreakerMetrics(MeterRegistry parent, MeterIdPrefix idPrefix) {
        Objects.requireNonNull(parent, "parent");
        Objects.requireNonNull(idPrefix, "idPrefix");
        parent.gauge(idPrefix.name("state"), idPrefix.tags(), this.state, AtomicDouble::get);
        String requests = idPrefix.name("requests");
        parent.gauge(requests, idPrefix.tags("result", "success"), this.latestEventCount, lec -> {
            EventCount eventCount = (EventCount)lec.get();
            assert (eventCount != null);
            return eventCount.success();
        });
        parent.gauge(requests, idPrefix.tags("result", "failure"), this.latestEventCount, lec -> {
            EventCount eventCount = (EventCount)lec.get();
            assert (eventCount != null);
            return eventCount.failure();
        });
        String transitions = idPrefix.name("transitions");
        this.transitionsToClosed = parent.counter(transitions, idPrefix.tags("state", CircuitState.CLOSED.name()));
        this.transitionsToOpen = parent.counter(transitions, idPrefix.tags("state", CircuitState.OPEN.name()));
        this.transitionsToHalfOpen = parent.counter(transitions, idPrefix.tags("state", CircuitState.HALF_OPEN.name()));
        this.transitionsToForcedOpen = parent.counter(transitions, idPrefix.tags("state", CircuitState.FORCED_OPEN.name()));
        this.rejectedRequests = parent.counter(idPrefix.name("rejected.requests"), idPrefix.tags());
    }

    void onStateChanged(CircuitState state) {
        switch (state) {
            case CLOSED: {
                this.state.set(1.0);
                this.transitionsToClosed.increment();
                break;
            }
            case OPEN: {
                this.state.set(0.0);
                this.transitionsToOpen.increment();
                break;
            }
            case HALF_OPEN: {
                this.state.set(0.5);
                this.transitionsToHalfOpen.increment();
                break;
            }
            case FORCED_OPEN: {
                this.state.set(0.0);
                this.transitionsToForcedOpen.increment();
                break;
            }
            default: {
                throw new Error("unknown circuit state: " + (Object)((Object)state));
            }
        }
    }

    void onCountUpdated(EventCount count) {
        this.latestEventCount.set(count);
    }

    void onRequestRejected() {
        this.rejectedRequests.increment();
    }
}

