/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.client;

import io.opentelemetry.testing.internal.armeria.client.UnprocessedRequestException;
import io.opentelemetry.testing.internal.armeria.common.TimeoutException;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.util.Exceptions;
import io.opentelemetry.testing.internal.armeria.internal.client.dns.DnsUtil;
import io.opentelemetry.testing.internal.io.netty.channel.ConnectTimeoutException;
import io.opentelemetry.testing.internal.io.netty.handler.proxy.ProxyConnectException;

final class TimeoutExceptionPredicate {
    static boolean isTimeoutException(@Nullable Throwable cause) {
        String message;
        if (cause == null) {
            return false;
        }
        if ((cause = TimeoutExceptionPredicate.peel(cause)) instanceof TimeoutException) {
            return true;
        }
        if (cause instanceof ConnectTimeoutException) {
            return true;
        }
        if (cause instanceof ProxyConnectException && (message = cause.getMessage()) != null && message.contains("timeout")) {
            return true;
        }
        return DnsUtil.isDnsQueryTimedOut(cause);
    }

    private static Throwable peel(Throwable cause) {
        if ((cause = Exceptions.peel(cause)) instanceof UnprocessedRequestException) {
            cause = cause.getCause();
        }
        assert (cause != null);
        return cause;
    }

    private TimeoutExceptionPredicate() {
    }
}

