/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.client;

import io.opentelemetry.testing.internal.armeria.client.ClientBuilderParams;
import io.opentelemetry.testing.internal.armeria.client.DefaultRestClient;
import io.opentelemetry.testing.internal.armeria.client.HttpClient;
import io.opentelemetry.testing.internal.armeria.client.HttpPreprocessor;
import io.opentelemetry.testing.internal.armeria.client.RestClientBuilder;
import io.opentelemetry.testing.internal.armeria.client.RestClientPreparation;
import io.opentelemetry.testing.internal.armeria.client.WebClient;
import io.opentelemetry.testing.internal.armeria.client.endpoint.EndpointGroup;
import io.opentelemetry.testing.internal.armeria.common.HttpMethod;
import io.opentelemetry.testing.internal.armeria.common.SessionProtocol;
import io.opentelemetry.testing.internal.armeria.common.annotation.UnstableApi;
import io.opentelemetry.testing.internal.armeria.common.util.Unwrappable;
import java.net.URI;
import java.util.Objects;

@UnstableApi
public interface RestClient
extends ClientBuilderParams,
Unwrappable {
    public static RestClient of() {
        return DefaultRestClient.DEFAULT;
    }

    public static RestClient of(WebClient webClient) {
        Objects.requireNonNull(webClient, "webClient");
        if (webClient == WebClient.of()) {
            return RestClient.of();
        }
        return new DefaultRestClient(webClient);
    }

    public static RestClient of(String uri) {
        return RestClient.builder(uri).build();
    }

    public static RestClient of(URI uri) {
        return RestClient.builder(uri).build();
    }

    public static RestClient of(String protocol, EndpointGroup endpointGroup) {
        return RestClient.builder(protocol, endpointGroup).build();
    }

    public static RestClient of(SessionProtocol protocol, EndpointGroup endpointGroup) {
        return RestClient.builder(protocol, endpointGroup).build();
    }

    public static RestClient of(String protocol, EndpointGroup endpointGroup, String path) {
        return RestClient.builder(protocol, endpointGroup, path).build();
    }

    public static RestClient of(SessionProtocol protocol, EndpointGroup endpointGroup, String path) {
        return RestClient.builder(protocol, endpointGroup, path).build();
    }

    @UnstableApi
    public static RestClient of(HttpPreprocessor httpPreprocessor) {
        return RestClient.builder(httpPreprocessor).build();
    }

    @UnstableApi
    public static RestClient of(HttpPreprocessor httpPreprocessor, String path) {
        return RestClient.builder(httpPreprocessor, path).build();
    }

    public static RestClientBuilder builder() {
        return new RestClientBuilder();
    }

    public static RestClientBuilder builder(String uri) {
        return RestClient.builder(URI.create(Objects.requireNonNull(uri, "uri")));
    }

    public static RestClientBuilder builder(URI uri) {
        return new RestClientBuilder(uri);
    }

    public static RestClientBuilder builder(String protocol, EndpointGroup endpointGroup) {
        return RestClient.builder(SessionProtocol.of(Objects.requireNonNull(protocol, "protocol")), endpointGroup);
    }

    public static RestClientBuilder builder(SessionProtocol protocol, EndpointGroup endpointGroup) {
        Objects.requireNonNull(protocol, "protocol");
        Objects.requireNonNull(endpointGroup, "endpointGroup");
        return new RestClientBuilder(protocol, endpointGroup, null);
    }

    public static RestClientBuilder builder(String protocol, EndpointGroup endpointGroup, String path) {
        Objects.requireNonNull(protocol, "protocol");
        Objects.requireNonNull(endpointGroup, "endpointGroup");
        Objects.requireNonNull(path, "path");
        return RestClient.builder(SessionProtocol.of(protocol), endpointGroup, path);
    }

    public static RestClientBuilder builder(SessionProtocol protocol, EndpointGroup endpointGroup, String path) {
        Objects.requireNonNull(protocol, "protocol");
        Objects.requireNonNull(endpointGroup, "endpointGroup");
        Objects.requireNonNull(path, "path");
        return new RestClientBuilder(protocol, endpointGroup, path);
    }

    @UnstableApi
    public static RestClientBuilder builder(HttpPreprocessor httpPreprocessor) {
        Objects.requireNonNull(httpPreprocessor, "httpPreprocessor");
        return new RestClientBuilder(httpPreprocessor, null);
    }

    @UnstableApi
    public static RestClientBuilder builder(HttpPreprocessor httpPreprocessor, String path) {
        Objects.requireNonNull(httpPreprocessor, "httpPreprocessor");
        Objects.requireNonNull(path, "path");
        return new RestClientBuilder(httpPreprocessor, path);
    }

    default public RestClientPreparation get(String path) {
        return this.path(HttpMethod.GET, path);
    }

    default public RestClientPreparation post(String path) {
        return this.path(HttpMethod.POST, path);
    }

    default public RestClientPreparation put(String path) {
        return this.path(HttpMethod.PUT, path);
    }

    default public RestClientPreparation patch(String path) {
        return this.path(HttpMethod.PATCH, path);
    }

    default public RestClientPreparation delete(String path) {
        return this.path(HttpMethod.DELETE, path);
    }

    public RestClientPreparation path(HttpMethod var1, String var2);

    @Override
    public HttpClient unwrap();
}

