/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.client;

import io.opentelemetry.testing.internal.armeria.client.DefaultRequestOptions;
import io.opentelemetry.testing.internal.armeria.client.RequestOptions;
import io.opentelemetry.testing.internal.armeria.client.RequestOptionsSetters;
import io.opentelemetry.testing.internal.armeria.client.ResponseTimeoutMode;
import io.opentelemetry.testing.internal.armeria.common.ExchangeType;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.annotation.UnstableApi;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.Preconditions;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableMap;
import io.opentelemetry.testing.internal.io.netty.util.AttributeKey;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public final class RequestOptionsBuilder
implements RequestOptionsSetters {
    private long responseTimeoutMillis = -1L;
    private long writeTimeoutMillis = -1L;
    private long maxResponseLength = -1L;
    @Nullable
    private Long requestAutoAbortDelayMillis;
    @Nullable
    private ResponseTimeoutMode responseTimeoutMode;
    @Nullable
    private Map<AttributeKey<?>, Object> attributes;
    @Nullable
    private ExchangeType exchangeType;

    RequestOptionsBuilder(@Nullable RequestOptions options) {
        if (options != null) {
            this.responseTimeoutMillis = options.responseTimeoutMillis();
            this.writeTimeoutMillis = options.writeTimeoutMillis();
            this.maxResponseLength = options.maxResponseLength();
            this.requestAutoAbortDelayMillis = options.requestAutoAbortDelayMillis();
            Map<AttributeKey<?>, Object> attrs = options.attrs();
            if (!attrs.isEmpty()) {
                this.attributes = new HashMap(attrs);
            }
            this.exchangeType = options.exchangeType();
            this.responseTimeoutMode = options.responseTimeoutMode();
        }
    }

    @Override
    public RequestOptionsBuilder responseTimeout(Duration responseTimeout) {
        this.responseTimeoutMillis(Objects.requireNonNull(responseTimeout, "responseTimeout").toMillis());
        return this;
    }

    @Override
    public RequestOptionsBuilder responseTimeoutMillis(long responseTimeoutMillis) {
        Preconditions.checkArgument(responseTimeoutMillis >= 0L, "responseTimeoutMillis: %s (expected: >= 0)", responseTimeoutMillis);
        this.responseTimeoutMillis = responseTimeoutMillis;
        return this;
    }

    @Override
    public RequestOptionsBuilder writeTimeout(Duration writeTimeout) {
        this.writeTimeoutMillis(Objects.requireNonNull(writeTimeout, "writeTimeout").toMillis());
        return this;
    }

    @Override
    public RequestOptionsBuilder writeTimeoutMillis(long writeTimeoutMillis) {
        Preconditions.checkArgument(writeTimeoutMillis >= 0L, "writeTimeoutMillis: %s (expected: >= 0)", writeTimeoutMillis);
        this.writeTimeoutMillis = writeTimeoutMillis;
        return this;
    }

    @Override
    public RequestOptionsBuilder maxResponseLength(long maxResponseLength) {
        Preconditions.checkArgument(maxResponseLength >= 0L, "maxResponseLength: %s (expected: >= 0)", maxResponseLength);
        this.maxResponseLength = maxResponseLength;
        return this;
    }

    @Override
    public RequestOptionsBuilder requestAutoAbortDelay(Duration delay) {
        return this.requestAutoAbortDelayMillis(Objects.requireNonNull(delay, "delay").toMillis());
    }

    @Override
    public RequestOptionsBuilder requestAutoAbortDelayMillis(long delayMillis) {
        this.requestAutoAbortDelayMillis = delayMillis;
        return this;
    }

    @Override
    public <V> RequestOptionsBuilder attr(AttributeKey<V> key, @Nullable V value) {
        Objects.requireNonNull(key, "key");
        if (this.attributes == null) {
            this.attributes = new HashMap();
        }
        if (value == null) {
            this.attributes.remove(key);
        } else {
            this.attributes.put(key, value);
        }
        return this;
    }

    @Nullable
    ExchangeType exchangeType() {
        return this.exchangeType;
    }

    @Override
    public RequestOptionsBuilder exchangeType(ExchangeType exchangeType) {
        Objects.requireNonNull(exchangeType, "exchangeType");
        this.exchangeType = exchangeType;
        return this;
    }

    @Override
    @UnstableApi
    public RequestOptionsBuilder responseTimeoutMode(ResponseTimeoutMode responseTimeoutMode) {
        this.responseTimeoutMode = Objects.requireNonNull(responseTimeoutMode, "responseTimeoutMode");
        return this;
    }

    public RequestOptions build() {
        if (this.responseTimeoutMillis < 0L && this.writeTimeoutMillis < 0L && this.maxResponseLength < 0L && this.requestAutoAbortDelayMillis == null && this.attributes == null && this.exchangeType == null && this.responseTimeoutMode == null) {
            return DefaultRequestOptions.EMPTY;
        }
        ImmutableMap<Object, Object> attributes = this.attributes == null || this.attributes.isEmpty() ? ImmutableMap.of() : ImmutableMap.copyOf(this.attributes);
        return new DefaultRequestOptions(this.responseTimeoutMillis, this.writeTimeoutMillis, this.maxResponseLength, this.requestAutoAbortDelayMillis, attributes, this.exchangeType, this.responseTimeoutMode);
    }
}

