/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.client;

import io.opentelemetry.testing.internal.armeria.client.InvalidResponseException;
import io.opentelemetry.testing.internal.armeria.common.AggregatedHttpResponse;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.annotation.UnstableApi;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.Preconditions;
import java.util.Objects;

@UnstableApi
public final class InvalidHttpResponseException
extends InvalidResponseException {
    private static final long serialVersionUID = 3883287492432644897L;
    private final AggregatedHttpResponse response;

    public InvalidHttpResponseException(AggregatedHttpResponse response) {
        this(response, null);
    }

    public InvalidHttpResponseException(AggregatedHttpResponse response, @Nullable Throwable cause) {
        super(Objects.requireNonNull(response, "response").toString(), cause);
        InvalidHttpResponseException.ensureNonPooledObject(response);
        this.response = response;
    }

    public InvalidHttpResponseException(AggregatedHttpResponse response, String message, @Nullable Throwable cause) {
        super(Objects.requireNonNull(message, "message"), cause);
        Objects.requireNonNull(response, "response");
        InvalidHttpResponseException.ensureNonPooledObject(response);
        this.response = response;
    }

    public AggregatedHttpResponse response() {
        return this.response;
    }

    private static void ensureNonPooledObject(AggregatedHttpResponse response) {
        Preconditions.checkArgument(!response.content().isPooled(), "Cannot create an %s with the pooled content: %s (expected: a non-pooled content)", (Object)InvalidHttpResponseException.class.getSimpleName(), (Object)response);
    }
}

