/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.client;

import io.opentelemetry.testing.internal.armeria.client.AbstractHttpRequestHandler;
import io.opentelemetry.testing.internal.armeria.client.ClientRequestContext;
import io.opentelemetry.testing.internal.armeria.client.ResponseTimeoutMode;
import io.opentelemetry.testing.internal.armeria.common.HttpData;
import io.opentelemetry.testing.internal.armeria.common.HttpHeaders;
import io.opentelemetry.testing.internal.armeria.common.HttpObject;
import io.opentelemetry.testing.internal.armeria.common.HttpRequest;
import io.opentelemetry.testing.internal.armeria.common.ResponseCompleteException;
import io.opentelemetry.testing.internal.armeria.common.ResponseHeaders;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.logging.RequestLogProperty;
import io.opentelemetry.testing.internal.armeria.common.stream.CancelledSubscriptionException;
import io.opentelemetry.testing.internal.armeria.common.stream.StreamWriter;
import io.opentelemetry.testing.internal.armeria.common.stream.SubscriptionOption;
import io.opentelemetry.testing.internal.armeria.common.util.Exceptions;
import io.opentelemetry.testing.internal.armeria.common.util.SafeCloseable;
import io.opentelemetry.testing.internal.armeria.internal.client.ClientRequestContextExtension;
import io.opentelemetry.testing.internal.armeria.internal.client.DecodedHttpResponse;
import io.opentelemetry.testing.internal.armeria.internal.common.CancellationScheduler;
import io.opentelemetry.testing.internal.armeria.internal.common.RequestContextUtil;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.MoreObjects;
import io.opentelemetry.testing.internal.armeria.unsafe.PooledObjects;
import io.opentelemetry.testing.internal.io.netty.channel.EventLoop;
import io.opentelemetry.testing.internal.io.netty.util.concurrent.EventExecutor;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.reactivestreams.Subscriber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HttpResponseWrapper
implements StreamWriter<HttpObject> {
    private static final Logger logger = LoggerFactory.getLogger(HttpResponseWrapper.class);
    @Nullable
    private final AbstractHttpRequestHandler requestHandler;
    private final DecodedHttpResponse delegate;
    private final EventLoop eventLoop;
    private final ClientRequestContext ctx;
    private final long maxContentLength;
    static final String UNEXPECTED_EXCEPTION_MSG = "{} Unexpected exception while closing a request";
    private boolean responseStarted;
    private long contentLengthHeaderValue = -1L;
    private boolean done;
    private boolean closed;

    HttpResponseWrapper(@Nullable AbstractHttpRequestHandler requestHandler, DecodedHttpResponse delegate, EventLoop eventLoop, ClientRequestContext ctx, long maxContentLength) {
        this.requestHandler = requestHandler;
        this.delegate = delegate;
        this.eventLoop = eventLoop;
        this.ctx = ctx;
        this.maxContentLength = maxContentLength;
    }

    void handle100Continue(ResponseHeaders responseHeaders) {
        if (this.requestHandler != null) {
            this.requestHandler.handle100Continue(responseHeaders);
        }
    }

    DecodedHttpResponse delegate() {
        return this.delegate;
    }

    long maxContentLength() {
        return this.maxContentLength;
    }

    long writtenBytes() {
        return this.delegate.writtenBytes();
    }

    long contentLengthHeaderValue() {
        return this.contentLengthHeaderValue;
    }

    @Override
    public boolean isOpen() {
        return this.delegate.isOpen();
    }

    @Override
    public boolean isEmpty() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long demand() {
        throw new UnsupportedOperationException();
    }

    @Override
    public CompletableFuture<Void> whenComplete() {
        return this.delegate.whenComplete();
    }

    @Override
    public void subscribe(Subscriber<? super HttpObject> subscriber, EventExecutor executor, SubscriptionOption ... options) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void abort() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void abort(Throwable cause) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean tryWrite(HttpObject o) {
        if (this.done) {
            PooledObjects.close(o);
            return false;
        }
        return this.delegate.tryWrite(o);
    }

    void startResponse() {
        if (this.responseStarted) {
            return;
        }
        this.responseStarted = true;
        this.ctx.logBuilder().startResponse();
        this.ctx.logBuilder().responseFirstBytesTransferred();
        this.initTimeout();
    }

    boolean tryWriteResponseHeaders(ResponseHeaders responseHeaders) {
        this.contentLengthHeaderValue = responseHeaders.contentLength();
        this.ctx.logBuilder().defer(RequestLogProperty.RESPONSE_HEADERS);
        try {
            boolean bl = this.delegate.tryWrite(responseHeaders);
            return bl;
        }
        finally {
            this.ctx.logBuilder().responseHeaders(responseHeaders);
        }
    }

    boolean tryWriteData(HttpData data) {
        if (this.done) {
            PooledObjects.close(data);
            return false;
        }
        data.touch(this.ctx);
        this.ctx.logBuilder().increaseResponseLength(data);
        return this.delegate.tryWrite(data);
    }

    boolean tryWriteTrailers(HttpHeaders trailers) {
        if (this.done) {
            return false;
        }
        this.done = true;
        this.ctx.logBuilder().defer(RequestLogProperty.RESPONSE_TRAILERS);
        try {
            boolean bl = this.delegate.tryWrite(trailers);
            return bl;
        }
        finally {
            this.ctx.logBuilder().responseTrailers(trailers);
        }
    }

    @Override
    public CompletableFuture<Void> whenConsumed() {
        return this.delegate.whenConsumed();
    }

    void onSubscriptionCancelled(@Nullable Throwable cause) {
        this.close(cause, true);
    }

    @Override
    public void close() {
        this.close(null, false);
    }

    @Override
    public void close(Throwable cause) {
        this.close(cause, false);
    }

    void close(@Nullable Throwable cause, boolean cancel) {
        if (this.closed) {
            return;
        }
        this.done = true;
        this.closed = true;
        this.cancelTimeoutAndLog(cause, cancel);
        HttpRequest request = this.ctx.request();
        assert (request != null);
        if (cause != null) {
            request.abort(cause);
            return;
        }
        long requestAutoAbortDelayMillis = this.ctx.requestAutoAbortDelayMillis();
        if (requestAutoAbortDelayMillis < 0L || requestAutoAbortDelayMillis == Long.MAX_VALUE) {
            return;
        }
        if (requestAutoAbortDelayMillis == 0L) {
            request.abort(ResponseCompleteException.get());
            return;
        }
        this.ctx.eventLoop().schedule(() -> request.abort(ResponseCompleteException.get()), requestAutoAbortDelayMillis, TimeUnit.MILLISECONDS);
    }

    private boolean closeAction(@Nullable Throwable cause) {
        boolean closed;
        if (cause != null) {
            closed = this.delegate.tryClose(cause);
            this.ctx.logBuilder().endResponse(cause);
        } else {
            closed = this.delegate.tryClose();
            this.ctx.logBuilder().endResponse();
        }
        return closed;
    }

    private void cancelAction(@Nullable Throwable cause) {
        if (cause != null && !(cause instanceof CancelledSubscriptionException)) {
            this.ctx.logBuilder().endResponse(cause);
        } else {
            this.ctx.logBuilder().endResponse();
        }
    }

    private void cancelTimeoutAndLog(@Nullable Throwable cause, boolean cancel) {
        ClientRequestContextExtension ctxExtension = this.ctx.as(ClientRequestContextExtension.class);
        if (ctxExtension != null) {
            ctxExtension.responseCancellationScheduler().cancelScheduled();
        }
        if (cancel) {
            this.cancelAction(cause);
            return;
        }
        if (this.delegate.isOpen() && this.closeAction(cause)) {
            return;
        }
        if (cause == this.ctx.cancellationCause()) {
            return;
        }
        if (cause == null || !logger.isWarnEnabled() || Exceptions.isExpected(cause)) {
            return;
        }
        logger.warn(UNEXPECTED_EXCEPTION_MSG, (Object)this.ctx, (Object)cause);
    }

    void initTimeout() {
        ClientRequestContextExtension ctxExtension = this.ctx.as(ClientRequestContextExtension.class);
        if (ctxExtension != null) {
            CancellationScheduler responseCancellationScheduler = ctxExtension.responseCancellationScheduler();
            responseCancellationScheduler.updateTask(this.newCancellationTask());
            if (this.ctx.responseTimeoutMode() == ResponseTimeoutMode.REQUEST_SENT) {
                responseCancellationScheduler.start();
            }
        }
    }

    private CancellationScheduler.CancellationTask newCancellationTask() {
        return new CancellationScheduler.CancellationTask(){

            @Override
            public boolean canSchedule() {
                return HttpResponseWrapper.this.delegate.isOpen() && !HttpResponseWrapper.this.done;
            }

            @Override
            public void run(Throwable cause) {
                if (HttpResponseWrapper.this.ctx.eventLoop().inEventLoop()) {
                    try (SafeCloseable ignored = RequestContextUtil.pop();){
                        HttpResponseWrapper.this.close(cause);
                    }
                } else {
                    HttpResponseWrapper.this.ctx.eventLoop().withoutContext().execute(() -> HttpResponseWrapper.this.close(cause));
                }
            }
        };
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).omitNullValues().add("ctx", this.ctx).add("eventLoop", this.eventLoop).add("responseStarted", this.responseStarted).add("maxContentLength", this.maxContentLength).add("contentLengthHeaderValue", this.contentLengthHeaderValue).add("delegate", this.delegate).toString();
    }
}

