/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.client;

import io.opentelemetry.testing.internal.armeria.client.BlockingWebClient;
import io.opentelemetry.testing.internal.armeria.client.ClientBuilderParams;
import io.opentelemetry.testing.internal.armeria.client.ClientFactory;
import io.opentelemetry.testing.internal.armeria.client.ClientFactoryOptions;
import io.opentelemetry.testing.internal.armeria.client.ClientOptions;
import io.opentelemetry.testing.internal.armeria.client.ClientTlsConfig;
import io.opentelemetry.testing.internal.armeria.client.Clients;
import io.opentelemetry.testing.internal.armeria.client.ConnectionPoolListener;
import io.opentelemetry.testing.internal.armeria.client.DefaultWebClient;
import io.opentelemetry.testing.internal.armeria.client.Endpoint;
import io.opentelemetry.testing.internal.armeria.client.EventLoopScheduler;
import io.opentelemetry.testing.internal.armeria.client.HttpChannelPool;
import io.opentelemetry.testing.internal.armeria.client.HttpClient;
import io.opentelemetry.testing.internal.armeria.client.HttpClientDelegate;
import io.opentelemetry.testing.internal.armeria.client.NullTlsProvider;
import io.opentelemetry.testing.internal.armeria.client.RedirectingClient;
import io.opentelemetry.testing.internal.armeria.client.RestClient;
import io.opentelemetry.testing.internal.armeria.client.WebClient;
import io.opentelemetry.testing.internal.armeria.client.endpoint.EndpointGroup;
import io.opentelemetry.testing.internal.armeria.client.proxy.ProxyConfigSelector;
import io.opentelemetry.testing.internal.armeria.client.redirect.RedirectConfig;
import io.opentelemetry.testing.internal.armeria.common.Http1HeaderNaming;
import io.opentelemetry.testing.internal.armeria.common.NonBlocking;
import io.opentelemetry.testing.internal.armeria.common.RequestContext;
import io.opentelemetry.testing.internal.armeria.common.Scheme;
import io.opentelemetry.testing.internal.armeria.common.SerializationFormat;
import io.opentelemetry.testing.internal.armeria.common.SessionProtocol;
import io.opentelemetry.testing.internal.armeria.common.TlsProvider;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.metric.MeterIdPrefix;
import io.opentelemetry.testing.internal.armeria.common.metric.MoreMeterBinders;
import io.opentelemetry.testing.internal.armeria.common.util.AsyncCloseableSupport;
import io.opentelemetry.testing.internal.armeria.common.util.ReleasableHolder;
import io.opentelemetry.testing.internal.armeria.common.util.ShutdownHooks;
import io.opentelemetry.testing.internal.armeria.common.util.TlsEngineType;
import io.opentelemetry.testing.internal.armeria.common.util.TransportType;
import io.opentelemetry.testing.internal.armeria.internal.client.ClientBuilderParamsUtil;
import io.opentelemetry.testing.internal.armeria.internal.common.RequestTargetCache;
import io.opentelemetry.testing.internal.armeria.internal.common.SslContextFactory;
import io.opentelemetry.testing.internal.armeria.internal.common.util.ChannelUtil;
import io.opentelemetry.testing.internal.armeria.internal.common.util.SslContextUtil;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableSet;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.MapMaker;
import io.opentelemetry.testing.internal.io.micrometer.core.instrument.MeterRegistry;
import io.opentelemetry.testing.internal.io.netty.bootstrap.Bootstrap;
import io.opentelemetry.testing.internal.io.netty.channel.ChannelOption;
import io.opentelemetry.testing.internal.io.netty.channel.ChannelPipeline;
import io.opentelemetry.testing.internal.io.netty.channel.EventLoop;
import io.opentelemetry.testing.internal.io.netty.channel.EventLoopGroup;
import io.opentelemetry.testing.internal.io.netty.handler.ssl.SslContext;
import io.opentelemetry.testing.internal.io.netty.handler.ssl.SslContextBuilder;
import io.opentelemetry.testing.internal.io.netty.resolver.AddressResolverGroup;
import java.net.InetSocketAddress;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class HttpClientFactory
implements ClientFactory {
    private static final Logger logger = LoggerFactory.getLogger(HttpClientFactory.class);
    private static final CompletableFuture<?>[] EMPTY_FUTURES = new CompletableFuture[0];
    private static final Set<Scheme> SUPPORTED_SCHEMES = Arrays.stream(SessionProtocol.values()).flatMap(p -> Stream.of(Scheme.of(SerializationFormat.NONE, p), Scheme.of(SerializationFormat.WS, p))).collect(ImmutableSet.toImmutableSet());
    private final EventLoopGroup workerGroup;
    private final boolean shutdownWorkerGroupOnClose;
    private final Bootstrap inetBaseBootstrap;
    @Nullable
    private final Bootstrap unixBaseBootstrap;
    private final SslContext sslCtxHttp1Or2;
    private final SslContext sslCtxHttp1Only;
    @Nullable
    private final SslContextFactory sslContextFactory;
    private final AddressResolverGroup<InetSocketAddress> addressResolverGroup;
    private final int http2InitialConnectionWindowSize;
    private final int http2InitialStreamWindowSize;
    private final float http2StreamWindowUpdateRatio;
    private final int http2MaxFrameSize;
    private final long http2MaxHeaderListSize;
    private final int http1MaxInitialLineLength;
    private final int http1MaxHeaderSize;
    private final int http1MaxChunkSize;
    private final long idleTimeoutMillis;
    private final boolean keepAliveOnPing;
    private final long pingIntervalMillis;
    private final long maxConnectionAgeMillis;
    private final int maxNumRequestsPerConnection;
    private final boolean useHttp2Preface;
    private final boolean useHttp2WithoutAlpn;
    private final boolean useHttp1Pipelining;
    private final ConnectionPoolListener connectionPoolListener;
    private final long http2GracefulShutdownTimeoutMillis;
    private MeterRegistry meterRegistry;
    private final ProxyConfigSelector proxyConfigSelector;
    private final Http1HeaderNaming http1HeaderNaming;
    private final Consumer<? super ChannelPipeline> channelPipelineCustomizer;
    private final ConcurrentMap<EventLoop, HttpChannelPool> pools = new MapMaker().weakKeys().makeMap();
    private final HttpClientDelegate clientDelegate;
    private final EventLoopScheduler eventLoopScheduler;
    private final Supplier<EventLoop> eventLoopSupplier = () -> RequestContext.mapCurrent(ctx -> ctx.eventLoop().withoutContext(), () -> this.eventLoopGroup().next());
    private final ClientFactoryOptions options;
    private final boolean autoCloseConnectionPoolListener;
    private final AsyncCloseableSupport closeable = AsyncCloseableSupport.of(this::closeAsync);

    private static void setupTlsMetrics(List<X509Certificate> certificates, MeterRegistry registry) {
        MeterIdPrefix meterIdPrefix = new MeterIdPrefix("armeria.client");
        try {
            MoreMeterBinders.certificateMetrics(certificates, meterIdPrefix).bindTo(registry);
        }
        catch (Exception ex) {
            logger.warn("Failed to set up TLS certificate metrics: {}", certificates, (Object)ex);
        }
    }

    HttpClientFactory(ClientFactoryOptions options, boolean autoCloseConnectionPoolListener) {
        this.workerGroup = options.workerGroup();
        AddressResolverGroup<? extends InetSocketAddress> group = options.addressResolverGroupFactory().apply(this.workerGroup);
        this.addressResolverGroup = group;
        Bootstrap bootstrap = new Bootstrap();
        bootstrap.resolver(this.addressResolverGroup);
        this.shutdownWorkerGroupOnClose = options.shutdownWorkerGroupOnClose();
        this.eventLoopScheduler = options.eventLoopSchedulerFactory().apply(this.workerGroup);
        this.inetBaseBootstrap = bootstrap.clone();
        this.inetBaseBootstrap.channel(TransportType.socketChannelType(this.workerGroup));
        options.channelOptions().forEach((option, value) -> {
            ChannelOption castOption = option;
            this.inetBaseBootstrap.option(castOption, value);
        });
        if (TransportType.supportsDomainSockets(this.workerGroup)) {
            this.unixBaseBootstrap = bootstrap.clone();
            this.unixBaseBootstrap.channel(TransportType.domainSocketChannelType(this.workerGroup));
            options.channelOptions().forEach((option, value) -> {
                if (!ChannelUtil.isTcpOption(option)) {
                    ChannelOption castOption = option;
                    this.unixBaseBootstrap.option(castOption, value);
                }
            });
        } else {
            this.unixBaseBootstrap = null;
        }
        Consumer<? super SslContextBuilder> tlsCustomizer = options.tlsCustomizer();
        boolean tlsAllowUnsafeCiphers = options.tlsAllowUnsafeCiphers();
        ArrayList<X509Certificate> keyCertChainCaptor = new ArrayList<X509Certificate>();
        TlsEngineType tlsEngineType = options.tlsEngineType();
        this.sslCtxHttp1Or2 = SslContextUtil.createSslContext(SslContextBuilder::forClient, false, tlsEngineType, tlsAllowUnsafeCiphers, tlsCustomizer, keyCertChainCaptor);
        this.sslCtxHttp1Only = SslContextUtil.createSslContext(SslContextBuilder::forClient, true, tlsEngineType, tlsAllowUnsafeCiphers, tlsCustomizer, keyCertChainCaptor);
        HttpClientFactory.setupTlsMetrics(keyCertChainCaptor, options.meterRegistry());
        TlsProvider tlsProvider = options.tlsProvider();
        if (tlsProvider != NullTlsProvider.INSTANCE) {
            ClientTlsConfig clientTlsConfig = options.tlsConfig();
            if (clientTlsConfig == ClientTlsConfig.NOOP) {
                clientTlsConfig = null;
            }
            this.sslContextFactory = new SslContextFactory(tlsProvider, options.tlsEngineType(), clientTlsConfig, options.meterRegistry());
        } else {
            this.sslContextFactory = null;
        }
        this.http2InitialConnectionWindowSize = options.http2InitialConnectionWindowSize();
        this.http2InitialStreamWindowSize = options.http2InitialStreamWindowSize();
        this.http2StreamWindowUpdateRatio = options.http2StreamWindowUpdateRatio();
        this.http2MaxFrameSize = options.http2MaxFrameSize();
        this.http2MaxHeaderListSize = options.http2MaxHeaderListSize();
        this.pingIntervalMillis = options.pingIntervalMillis();
        this.http1MaxInitialLineLength = options.http1MaxInitialLineLength();
        this.http1MaxHeaderSize = options.http1MaxHeaderSize();
        this.http1MaxChunkSize = options.http1MaxChunkSize();
        this.idleTimeoutMillis = options.idleTimeoutMillis();
        this.keepAliveOnPing = options.keepAliveOnPing();
        this.useHttp2Preface = options.useHttp2Preface();
        this.useHttp2WithoutAlpn = options.useHttp2WithoutAlpn();
        this.useHttp1Pipelining = options.useHttp1Pipelining();
        this.connectionPoolListener = options.connectionPoolListener();
        this.http2GracefulShutdownTimeoutMillis = options.http2GracefulShutdownTimeoutMillis();
        this.meterRegistry = options.meterRegistry();
        this.proxyConfigSelector = options.proxyConfigSelector();
        this.http1HeaderNaming = options.http1HeaderNaming();
        this.maxConnectionAgeMillis = options.maxConnectionAgeMillis();
        this.maxNumRequestsPerConnection = options.maxNumRequestsPerConnection();
        this.channelPipelineCustomizer = options.channelPipelineCustomizer();
        this.autoCloseConnectionPoolListener = autoCloseConnectionPoolListener;
        this.options = options;
        this.clientDelegate = new HttpClientDelegate(this, this.addressResolverGroup);
        RequestTargetCache.registerClientMetrics(this.meterRegistry);
    }

    Bootstrap newInetBootstrap() {
        return this.inetBaseBootstrap.clone();
    }

    @Nullable
    Bootstrap newUnixBootstrap() {
        if (this.unixBaseBootstrap == null) {
            return null;
        }
        return this.unixBaseBootstrap.clone();
    }

    int http2InitialConnectionWindowSize() {
        return this.http2InitialConnectionWindowSize;
    }

    int http2InitialStreamWindowSize() {
        return this.http2InitialStreamWindowSize;
    }

    float http2StreamWindowUpdateRatio() {
        return this.http2StreamWindowUpdateRatio;
    }

    int http2MaxFrameSize() {
        return this.http2MaxFrameSize;
    }

    long http2MaxHeaderListSize() {
        return this.http2MaxHeaderListSize;
    }

    int http1MaxInitialLineLength() {
        return this.http1MaxInitialLineLength;
    }

    int http1MaxHeaderSize() {
        return this.http1MaxHeaderSize;
    }

    int http1MaxChunkSize() {
        return this.http1MaxChunkSize;
    }

    long idleTimeoutMillis() {
        return this.idleTimeoutMillis;
    }

    boolean keepAliveOnPing() {
        return this.keepAliveOnPing;
    }

    long pingIntervalMillis() {
        return this.pingIntervalMillis;
    }

    long maxConnectionAgeMillis() {
        return this.maxConnectionAgeMillis;
    }

    int maxNumRequestsPerConnection() {
        return this.maxNumRequestsPerConnection;
    }

    boolean useHttp2Preface() {
        return this.useHttp2Preface;
    }

    boolean useHttp2WithoutAlpn() {
        return this.useHttp2WithoutAlpn;
    }

    boolean useHttp1Pipelining() {
        return this.useHttp1Pipelining;
    }

    ConnectionPoolListener connectionPoolListener() {
        return this.connectionPoolListener;
    }

    long http2GracefulShutdownTimeoutMillis() {
        return this.http2GracefulShutdownTimeoutMillis;
    }

    ProxyConfigSelector proxyConfigSelector() {
        return this.proxyConfigSelector;
    }

    Http1HeaderNaming http1HeaderNaming() {
        return this.http1HeaderNaming;
    }

    AddressResolverGroup<InetSocketAddress> addressResolverGroup() {
        return this.addressResolverGroup;
    }

    Consumer<? super ChannelPipeline> channelPipelineCustomizer() {
        return this.channelPipelineCustomizer;
    }

    @Override
    public Set<Scheme> supportedSchemes() {
        return SUPPORTED_SCHEMES;
    }

    @Override
    public EventLoopGroup eventLoopGroup() {
        return this.workerGroup;
    }

    @Override
    public Supplier<EventLoop> eventLoopSupplier() {
        return this.eventLoopSupplier;
    }

    @Override
    public ReleasableHolder<EventLoop> acquireEventLoop(SessionProtocol sessionProtocol, EndpointGroup endpointGroup, @Nullable Endpoint endpoint) {
        return this.eventLoopScheduler.acquire(sessionProtocol, endpointGroup, endpoint);
    }

    @Override
    public MeterRegistry meterRegistry() {
        return this.meterRegistry;
    }

    @Override
    @Deprecated
    public void setMeterRegistry(MeterRegistry meterRegistry) {
        this.meterRegistry = Objects.requireNonNull(meterRegistry, "meterRegistry");
    }

    @Override
    public ClientFactoryOptions options() {
        return this.options;
    }

    @Override
    public Object newClient(ClientBuilderParams params) {
        this.validateParams(params);
        Class<?> clientType = params.clientType();
        HttpClientFactory.validateClientType(clientType);
        ClientOptions options = params.options();
        HttpClient delegate = options.decoration().decorate(this.clientDelegate);
        if (clientType == HttpClient.class) {
            return delegate;
        }
        if (clientType == WebClient.class || clientType == BlockingWebClient.class || clientType == RestClient.class) {
            RedirectConfig redirectConfig = options.redirectConfig();
            HttpClient delegate0 = redirectConfig == RedirectConfig.disabled() ? delegate : (HttpClient)RedirectingClient.newDecorator(params, redirectConfig).apply(delegate);
            DefaultWebClient webClient = new DefaultWebClient(params, delegate0, this.meterRegistry);
            if (clientType == WebClient.class) {
                return webClient;
            }
            if (clientType == BlockingWebClient.class) {
                return webClient.blocking();
            }
            return webClient.asRestClient();
        }
        throw new IllegalArgumentException("unsupported client type: " + clientType.getName());
    }

    private static Class<?> validateClientType(Class<?> clientType) {
        if (clientType != WebClient.class && clientType != HttpClient.class && clientType != BlockingWebClient.class && clientType != RestClient.class) {
            throw new IllegalArgumentException("clientType: " + clientType + " (expected: " + WebClient.class.getSimpleName() + ", " + BlockingWebClient.class.getSimpleName() + ", " + RestClient.class.getSimpleName() + " or " + HttpClient.class.getSimpleName() + ')');
        }
        return clientType;
    }

    @Override
    public ClientBuilderParams validateParams(ClientBuilderParams params) {
        if (ClientBuilderParamsUtil.isPreprocessorUri(params.uri()) && params.options().clientPreprocessors().preprocessors().isEmpty() && params.clientType() != HttpClient.class) {
            throw new IllegalArgumentException("At least one preprocessor must be specified for http-based clients with sessionProtocol '" + (Object)((Object)params.scheme().sessionProtocol()) + "' and clientType '" + params.clientType() + "'.");
        }
        if (Clients.isUndefinedUri(params.uri()) && !"/".equals(params.absolutePathRef())) {
            throw new IllegalArgumentException("Cannot set a prefix path for clients created by 'WebClient.of().'");
        }
        return ClientFactory.super.validateParams(params);
    }

    @Override
    public boolean isClosing() {
        return this.closeable.isClosing();
    }

    @Override
    public boolean isClosed() {
        return this.closeable.isClosed();
    }

    @Override
    public CompletableFuture<?> whenClosed() {
        return this.closeable.whenClosed();
    }

    @Override
    public CompletableFuture<?> closeAsync() {
        return this.closeable.closeAsync();
    }

    private void closeAsync(CompletableFuture<?> future) {
        ArrayList dependencies = new ArrayList(this.pools.size());
        Iterator i = this.pools.values().iterator();
        while (i.hasNext()) {
            dependencies.add(((HttpChannelPool)i.next()).closeAsync());
            i.remove();
        }
        this.addressResolverGroup.close();
        CompletableFuture.allOf(dependencies.toArray(EMPTY_FUTURES)).handle((unused, cause) -> {
            if (cause != null) {
                logger.warn("Failed to close {}s:", (Object)HttpChannelPool.class.getSimpleName(), cause);
            }
            if (this.autoCloseConnectionPoolListener) {
                this.connectionPoolListener.close();
            }
            if (this.shutdownWorkerGroupOnClose) {
                this.workerGroup.shutdownGracefully().addListener(f -> {
                    if (f.cause() != null) {
                        logger.warn("Failed to shut down a worker group:", f.cause());
                    }
                    future.complete(null);
                });
            } else {
                future.complete(null);
            }
            return null;
        });
    }

    @Override
    public void close() {
        if (Thread.currentThread() instanceof NonBlocking) {
            this.closeable.closeAsync();
        } else {
            this.closeable.close();
        }
    }

    @Override
    public int numConnections() {
        return this.pools.values().stream().mapToInt(HttpChannelPool::numConnections).sum();
    }

    @Override
    public CompletableFuture<Void> closeOnJvmShutdown(Runnable whenClosing) {
        Objects.requireNonNull(whenClosing, "whenClosing");
        return ShutdownHooks.addClosingTask(this, whenClosing);
    }

    HttpChannelPool pool(EventLoop eventLoop) {
        if (this.isClosing()) {
            throw new IllegalStateException("ClientFactory is closing or closed.");
        }
        HttpChannelPool pool = (HttpChannelPool)this.pools.get(eventLoop);
        if (pool != null) {
            return pool;
        }
        return this.pools.computeIfAbsent(eventLoop, e -> new HttpChannelPool(this, eventLoop, this.sslCtxHttp1Or2, this.sslCtxHttp1Only, this.sslContextFactory, this.connectionPoolListener()));
    }

    @Nullable
    SslContextFactory sslContextFactory() {
        return this.sslContextFactory;
    }
}

