/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.client;

import io.opentelemetry.testing.internal.armeria.client.ClientHttp1ObjectEncoder;
import io.opentelemetry.testing.internal.armeria.client.Http1ResponseDecoder;
import io.opentelemetry.testing.internal.armeria.common.HttpHeaderNames;
import io.opentelemetry.testing.internal.armeria.common.HttpMethod;
import io.opentelemetry.testing.internal.armeria.common.RequestHeaders;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.internal.client.HttpSession;
import io.opentelemetry.testing.internal.armeria.internal.client.UserAgentUtil;
import io.opentelemetry.testing.internal.armeria.internal.common.Http1KeepAliveHandler;
import io.opentelemetry.testing.internal.io.micrometer.core.instrument.Timer;
import io.opentelemetry.testing.internal.io.netty.channel.Channel;
import io.opentelemetry.testing.internal.io.netty.channel.ChannelFuture;
import io.opentelemetry.testing.internal.io.netty.channel.ChannelHandlerContext;
import java.util.Objects;

final class Http1ClientKeepAliveHandler
extends Http1KeepAliveHandler {
    private static final RequestHeaders HTTP1_PING_REQUEST = RequestHeaders.builder(HttpMethod.OPTIONS, "*").set((CharSequence)HttpHeaderNames.USER_AGENT, UserAgentUtil.USER_AGENT.toString()).build();
    private final HttpSession httpSession;
    private final Http1ResponseDecoder decoder;
    @Nullable
    private ClientHttp1ObjectEncoder encoder;

    Http1ClientKeepAliveHandler(Channel channel, Http1ResponseDecoder decoder, Timer keepAliveTimer, long idleTimeoutMillis, long pingIntervalMillis, long maxConnectionAgeMillis, int maxNumRequestsPerConnection, boolean keepAliveOnPing) {
        super(channel, "client", keepAliveTimer, idleTimeoutMillis, pingIntervalMillis, maxConnectionAgeMillis, maxNumRequestsPerConnection, keepAliveOnPing);
        this.httpSession = HttpSession.get(Objects.requireNonNull(channel, "channel"));
        this.decoder = Objects.requireNonNull(decoder, "decoder");
    }

    void setEncoder(ClientHttp1ObjectEncoder encoder) {
        this.encoder = Objects.requireNonNull(encoder, "encoder");
    }

    @Override
    protected ChannelFuture writePing(ChannelHandlerContext ctx) {
        int id = this.httpSession.incrementAndGetNumRequestsSent();
        assert (this.encoder != null);
        this.decoder.setPingReqId(id);
        ChannelFuture future = this.encoder.writeHeaders(id, 0, HTTP1_PING_REQUEST, true, ctx.newPromise());
        ctx.flush();
        return future;
    }

    @Override
    protected boolean pingResetsPreviousPing() {
        return false;
    }

    @Override
    protected boolean hasRequestsInProgress(ChannelHandlerContext ctx) {
        return this.httpSession.hasUnfinishedResponses();
    }

    boolean isPing(int id) {
        return this.decoder.isPingReqId(id);
    }
}

