/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.client;

import io.opentelemetry.testing.internal.armeria.client.ClientBuilderParams;
import io.opentelemetry.testing.internal.armeria.client.ClientFactoryBuilder;
import io.opentelemetry.testing.internal.armeria.client.ClientFactoryOptions;
import io.opentelemetry.testing.internal.armeria.client.DefaultClientFactory;
import io.opentelemetry.testing.internal.armeria.client.Endpoint;
import io.opentelemetry.testing.internal.armeria.client.endpoint.EndpointGroup;
import io.opentelemetry.testing.internal.armeria.common.NonBlocking;
import io.opentelemetry.testing.internal.armeria.common.Scheme;
import io.opentelemetry.testing.internal.armeria.common.SerializationFormat;
import io.opentelemetry.testing.internal.armeria.common.SessionProtocol;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.util.Exceptions;
import io.opentelemetry.testing.internal.armeria.common.util.ListenableAsyncCloseable;
import io.opentelemetry.testing.internal.armeria.common.util.ReleasableHolder;
import io.opentelemetry.testing.internal.armeria.common.util.ShutdownHooks;
import io.opentelemetry.testing.internal.armeria.common.util.Unwrappable;
import io.opentelemetry.testing.internal.armeria.internal.client.ClientBuilderParamsUtil;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.MoreObjects;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.Strings;
import io.opentelemetry.testing.internal.io.micrometer.core.instrument.MeterRegistry;
import io.opentelemetry.testing.internal.io.netty.channel.EventLoop;
import io.opentelemetry.testing.internal.io.netty.channel.EventLoopGroup;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface ClientFactory
extends ListenableAsyncCloseable,
Unwrappable {
    public static ClientFactory ofDefault() {
        return DefaultClientFactory.DEFAULT;
    }

    public static ClientFactory insecure() {
        return DefaultClientFactory.INSECURE;
    }

    public static ClientFactoryBuilder builder() {
        return new ClientFactoryBuilder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeDefault() {
        Logger logger = LoggerFactory.getLogger(ClientFactory.class);
        logger.debug("Closing the default client factories");
        CompletionStage closeFuture = CompletableFuture.allOf(DefaultClientFactory.DEFAULT.closeAsync(false), DefaultClientFactory.INSECURE.closeAsync(false)).handle((unused1, cause) -> {
            if (cause == null) {
                logger.debug("Closed the default client factories");
            } else {
                logger.warn("Failed to close the default client factories:", Exceptions.peel(cause));
            }
            return null;
        });
        if (!(Thread.currentThread() instanceof NonBlocking)) {
            boolean interrupted = false;
            try {
                while (true) {
                    try {
                        ((CompletableFuture)closeFuture).get();
                    }
                    catch (InterruptedException e) {
                        interrupted = true;
                        continue;
                    }
                    catch (CancellationException | ExecutionException ignored) {
                        // empty catch block
                    }
                    break;
                }
            }
            finally {
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    public static void disableShutdownHook() {
        DefaultClientFactory.disableShutdownHook0();
    }

    public Set<Scheme> supportedSchemes();

    default public boolean isClientTypeSupported(Class<?> clientType) {
        return true;
    }

    public EventLoopGroup eventLoopGroup();

    public Supplier<EventLoop> eventLoopSupplier();

    public ReleasableHolder<EventLoop> acquireEventLoop(SessionProtocol var1, EndpointGroup var2, @Nullable Endpoint var3);

    public MeterRegistry meterRegistry();

    @Deprecated
    public void setMeterRegistry(MeterRegistry var1);

    public ClientFactoryOptions options();

    public Object newClient(ClientBuilderParams var1);

    public int numConnections();

    @Nullable
    default public <T> ClientBuilderParams clientBuilderParams(T client) {
        return this.unwrap(client, ClientBuilderParams.class);
    }

    @Nullable
    default public <T> T unwrap(Object client, Class<T> type) {
        Objects.requireNonNull(client, "client");
        Objects.requireNonNull(type, "type");
        if (type.isInstance(client)) {
            return type.cast(client);
        }
        if (client instanceof Unwrappable) {
            return ((Unwrappable)client).as(type);
        }
        if (Proxy.isProxyClass(client.getClass())) {
            InvocationHandler handler = Proxy.getInvocationHandler(client);
            if (type.isInstance(handler)) {
                return type.cast(handler);
            }
            if (handler instanceof Unwrappable) {
                return ((Unwrappable)((Object)handler)).as(type);
            }
        }
        return null;
    }

    @Override
    default public ClientFactory unwrap() {
        return this;
    }

    default public URI validateUri(URI uri) {
        Objects.requireNonNull(uri, "uri");
        if (ClientBuilderParamsUtil.isInternalUri(uri)) {
            return uri;
        }
        if (uri.getAuthority() == null) {
            throw new IllegalArgumentException("URI with missing authority: " + uri);
        }
        String scheme = uri.getScheme();
        if (scheme == null) {
            throw new IllegalArgumentException("URI with missing scheme: " + uri);
        }
        Scheme parsedScheme = Scheme.tryParse(scheme);
        if (parsedScheme == null) {
            throw new IllegalArgumentException("URI with undefined scheme: " + uri);
        }
        Set<Scheme> supportedSchemes = this.supportedSchemes();
        if (!supportedSchemes.contains(parsedScheme)) {
            throw new IllegalArgumentException("URI with unsupported scheme: " + uri + " (expected: " + supportedSchemes + ')');
        }
        String parsedSchemeStr = parsedScheme.serializationFormat() == SerializationFormat.NONE ? parsedScheme.sessionProtocol().uriText() : parsedScheme.uriText();
        String path = Strings.emptyToNull(uri.getRawPath());
        if (scheme.equals(parsedSchemeStr) && path != null) {
            return uri;
        }
        try {
            return new URI(parsedSchemeStr, uri.getRawAuthority(), MoreObjects.firstNonNull(path, "/"), uri.getRawQuery(), uri.getRawFragment());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    default public Scheme validateScheme(Scheme scheme) {
        Objects.requireNonNull(scheme, "scheme");
        Set<Scheme> supportedSchemes = this.supportedSchemes();
        if (!supportedSchemes.contains(scheme)) {
            throw new IllegalArgumentException("Unsupported scheme: " + scheme + " (expected: " + supportedSchemes + ')');
        }
        return scheme;
    }

    default public ClientBuilderParams validateParams(ClientBuilderParams params) {
        Objects.requireNonNull(params, "params");
        if (params.options().factory() != this) {
            this.validateScheme(params.scheme());
        }
        return params;
    }

    default public CompletableFuture<Void> closeOnJvmShutdown() {
        return ShutdownHooks.addClosingTask(this);
    }

    public CompletableFuture<Void> closeOnJvmShutdown(Runnable var1);
}

