/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.client;

import io.opentelemetry.testing.internal.armeria.client.ClientDecoration;
import io.opentelemetry.testing.internal.armeria.client.DecoratingHttpClientFunction;
import io.opentelemetry.testing.internal.armeria.client.DecoratingRpcClientFunction;
import io.opentelemetry.testing.internal.armeria.client.FunctionalDecoratingHttpClient;
import io.opentelemetry.testing.internal.armeria.client.FunctionalDecoratingRpcClient;
import io.opentelemetry.testing.internal.armeria.client.HttpClient;
import io.opentelemetry.testing.internal.armeria.client.RpcClient;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

public final class ClientDecorationBuilder {
    private final List<Function<? super HttpClient, ? extends HttpClient>> decorators = new ArrayList<Function<? super HttpClient, ? extends HttpClient>>();
    private final List<Function<? super RpcClient, ? extends RpcClient>> rpcDecorators = new ArrayList<Function<? super RpcClient, ? extends RpcClient>>();

    ClientDecorationBuilder() {
    }

    public ClientDecorationBuilder add(ClientDecoration clientDecoration) {
        Objects.requireNonNull(clientDecoration, "clientDecoration");
        clientDecoration.decorators().forEach(this::add);
        clientDecoration.rpcDecorators().forEach(this::addRpc);
        return this;
    }

    public ClientDecorationBuilder add(Function<? super HttpClient, ? extends HttpClient> decorator) {
        this.decorators.add(Objects.requireNonNull(decorator, "decorator"));
        return this;
    }

    public ClientDecorationBuilder add(DecoratingHttpClientFunction decorator) {
        Objects.requireNonNull(decorator, "decorator");
        return this.add((? super HttpClient delegate) -> new FunctionalDecoratingHttpClient((HttpClient)delegate, decorator));
    }

    public ClientDecorationBuilder clear() {
        this.decorators.clear();
        this.rpcDecorators.clear();
        return this;
    }

    public ClientDecorationBuilder addRpc(Function<? super RpcClient, ? extends RpcClient> decorator) {
        this.rpcDecorators.add(Objects.requireNonNull(decorator, "decorator"));
        return this;
    }

    public ClientDecorationBuilder addRpc(DecoratingRpcClientFunction decorator) {
        Objects.requireNonNull(decorator, "decorator");
        return this.addRpc((? super RpcClient delegate) -> new FunctionalDecoratingRpcClient((RpcClient)delegate, decorator));
    }

    public ClientDecoration build() {
        return new ClientDecoration(this.decorators, this.rpcDecorators);
    }
}

