/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.client;

import io.opentelemetry.testing.internal.armeria.client.ClientBuilderParamsBuilder;
import io.opentelemetry.testing.internal.armeria.client.ClientOptions;
import io.opentelemetry.testing.internal.armeria.client.endpoint.EndpointGroup;
import io.opentelemetry.testing.internal.armeria.common.Scheme;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.annotation.UnstableApi;
import java.net.URI;
import java.util.Objects;

public interface ClientBuilderParams {
    public static ClientBuilderParams of(URI uri, Class<?> type, ClientOptions options) {
        Objects.requireNonNull(uri, "uri");
        Objects.requireNonNull(type, "type");
        Objects.requireNonNull(options, "options");
        return new ClientBuilderParamsBuilder(uri).options(options).clientType(type).build();
    }

    public static ClientBuilderParams of(Scheme scheme, EndpointGroup endpointGroup, @Nullable String absolutePathRef, Class<?> type, ClientOptions options) {
        Objects.requireNonNull(scheme, "scheme");
        Objects.requireNonNull(endpointGroup, "endpointGroup");
        Objects.requireNonNull(type, "type");
        Objects.requireNonNull(options, "options");
        return new ClientBuilderParamsBuilder(scheme, endpointGroup, absolutePathRef).clientType(type).options(options).build();
    }

    public Scheme scheme();

    public EndpointGroup endpointGroup();

    public String absolutePathRef();

    public URI uri();

    public Class<?> clientType();

    public ClientOptions options();

    @UnstableApi
    default public ClientBuilderParamsBuilder paramsBuilder() {
        return new ClientBuilderParamsBuilder(this);
    }
}

