/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.client;

import io.opentelemetry.testing.internal.armeria.client.InvalidHttpResponseException;
import io.opentelemetry.testing.internal.armeria.client.ResponseAs;
import io.opentelemetry.testing.internal.armeria.common.AggregatedHttpResponse;
import io.opentelemetry.testing.internal.armeria.common.ResponseEntity;
import io.opentelemetry.testing.internal.armeria.common.util.Exceptions;
import io.opentelemetry.testing.internal.jackson.core.type.TypeReference;
import io.opentelemetry.testing.internal.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.function.Predicate;

final class AggregatedResponseAs {
    static ResponseAs<AggregatedHttpResponse, ResponseEntity<byte[]>> bytes() {
        return response -> ResponseEntity.of(response.headers(), response.content().array(), response.trailers());
    }

    static ResponseAs<AggregatedHttpResponse, ResponseEntity<String>> string() {
        return response -> ResponseEntity.of(response.headers(), response.contentUtf8(), response.trailers());
    }

    static <T> ResponseAs<AggregatedHttpResponse, ResponseEntity<T>> json(Class<? extends T> clazz, ObjectMapper mapper) {
        return response -> AggregatedResponseAs.newJsonResponseEntity(response, bytes -> mapper.readValue(bytes, clazz));
    }

    static <T> ResponseAs<AggregatedHttpResponse, ResponseEntity<T>> json(TypeReference<? extends T> typeRef, ObjectMapper mapper) {
        return response -> AggregatedResponseAs.newJsonResponseEntity(response, bytes -> mapper.readValue(bytes, typeRef));
    }

    static <T> ResponseAs<AggregatedHttpResponse, ResponseEntity<T>> json(Class<? extends T> clazz, ObjectMapper mapper, Predicate<AggregatedHttpResponse> predicate) {
        return response -> AggregatedResponseAs.newJsonResponseEntity(response, bytes -> mapper.readValue(bytes, clazz), predicate);
    }

    static <T> ResponseAs<AggregatedHttpResponse, ResponseEntity<T>> json(TypeReference<? extends T> typeRef, ObjectMapper mapper, Predicate<AggregatedHttpResponse> predicate) {
        return response -> AggregatedResponseAs.newJsonResponseEntity(response, bytes -> mapper.readValue(bytes, typeRef), predicate);
    }

    private static <T> ResponseEntity<T> newJsonResponseEntity(AggregatedHttpResponse response, JsonDecoder<T> decoder, Predicate<AggregatedHttpResponse> predicate) {
        if (!predicate.test(response)) {
            throw AggregatedResponseAs.newInvalidHttpResponseException(response);
        }
        return AggregatedResponseAs.newJsonResponseEntity(response, decoder);
    }

    private static <T> ResponseEntity<T> newJsonResponseEntity(AggregatedHttpResponse response, JsonDecoder<T> decoder) {
        try {
            return ResponseEntity.of(response.headers(), decoder.decode(response.content().array()), response.trailers());
        }
        catch (IOException e) {
            return (ResponseEntity)Exceptions.throwUnsafely(new InvalidHttpResponseException(response, (Throwable)e));
        }
    }

    private static InvalidHttpResponseException newInvalidHttpResponseException(AggregatedHttpResponse response) {
        return new InvalidHttpResponseException(response, "status: " + response.status() + " (expect: the success class (2xx). response: " + response, null);
    }

    private AggregatedResponseAs() {
    }

    @FunctionalInterface
    private static interface JsonDecoder<T> {
        public T decode(byte[] var1) throws IOException;
    }
}

