/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.client;

import io.opentelemetry.testing.internal.armeria.client.ClientRequestContext;
import io.opentelemetry.testing.internal.armeria.client.TimeoutExceptionPredicate;
import io.opentelemetry.testing.internal.armeria.client.UnprocessedRequestException;
import io.opentelemetry.testing.internal.armeria.common.HttpHeaders;
import io.opentelemetry.testing.internal.armeria.common.HttpStatus;
import io.opentelemetry.testing.internal.armeria.common.HttpStatusClass;
import io.opentelemetry.testing.internal.armeria.common.RequestHeaders;
import io.opentelemetry.testing.internal.armeria.common.ResponseHeaders;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.annotation.UnstableApi;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.Preconditions;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableSet;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.Iterables;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.Sets;
import java.time.Duration;
import java.util.Objects;
import java.util.function.BiPredicate;

@UnstableApi
public abstract class AbstractRuleBuilder<SELF extends AbstractRuleBuilder<SELF>> {
    private final BiPredicate<ClientRequestContext, RequestHeaders> requestHeadersFilter;
    @Nullable
    private BiPredicate<ClientRequestContext, ResponseHeaders> responseHeadersFilter;
    @Nullable
    private BiPredicate<ClientRequestContext, HttpHeaders> responseTrailersFilter;
    @Nullable
    private BiPredicate<ClientRequestContext, Throwable> exceptionFilter;
    @Nullable
    private BiPredicate<ClientRequestContext, HttpHeaders> grpcTrailersFilter;
    @Nullable
    private BiPredicate<ClientRequestContext, Duration> totalDurationFilter;

    protected AbstractRuleBuilder(BiPredicate<? super ClientRequestContext, ? super RequestHeaders> requestHeadersFilter) {
        this.requestHeadersFilter = requestHeadersFilter;
    }

    final SELF self() {
        return (SELF)this;
    }

    public SELF onResponseHeaders(BiPredicate<? super ClientRequestContext, ? super ResponseHeaders> responseHeadersFilter) {
        this.responseHeadersFilter = AbstractRuleBuilder.combinePredicates(this.responseHeadersFilter, responseHeadersFilter, "responseHeadersFilter");
        return this.self();
    }

    public SELF onResponseTrailers(BiPredicate<? super ClientRequestContext, ? super HttpHeaders> responseTrailersFilter) {
        this.responseTrailersFilter = AbstractRuleBuilder.combinePredicates(this.responseTrailersFilter, responseTrailersFilter, "responseTrailersFilter");
        return this.self();
    }

    public SELF onGrpcTrailers(BiPredicate<? super ClientRequestContext, ? super HttpHeaders> grpcTrailersFilter) {
        this.grpcTrailersFilter = AbstractRuleBuilder.combinePredicates(this.grpcTrailersFilter, grpcTrailersFilter, "grpcTrailersFilter");
        return this.self();
    }

    public SELF onStatusClass(HttpStatusClass ... statusClasses) {
        return this.onStatusClass(ImmutableSet.copyOf(Objects.requireNonNull(statusClasses, "statusClasses")));
    }

    public SELF onStatusClass(Iterable<HttpStatusClass> statusClasses) {
        Objects.requireNonNull(statusClasses, "statusClasses");
        Preconditions.checkArgument(!Iterables.isEmpty(statusClasses), "statusClasses can't be empty.");
        ImmutableSet<HttpStatusClass> statusClasses0 = Sets.immutableEnumSet(statusClasses);
        this.onResponseHeaders((ctx, headers) -> statusClasses0.contains((Object)headers.status().codeClass()));
        return this.self();
    }

    public SELF onServerErrorStatus() {
        return this.onStatusClass(HttpStatusClass.SERVER_ERROR);
    }

    public SELF onStatus(HttpStatus ... statuses) {
        return this.onStatus(ImmutableSet.copyOf(Objects.requireNonNull(statuses, "statuses")));
    }

    public SELF onStatus(Iterable<HttpStatus> statuses) {
        Objects.requireNonNull(statuses, "statuses");
        Preconditions.checkArgument(!Iterables.isEmpty(statuses), "statuses can't be empty.");
        ImmutableSet<HttpStatus> statuses0 = ImmutableSet.copyOf(statuses);
        this.onResponseHeaders((ctx, headers) -> statuses0.contains(headers.status()));
        return this.self();
    }

    public SELF onStatus(BiPredicate<? super ClientRequestContext, ? super HttpStatus> statusFilter) {
        Objects.requireNonNull(statusFilter, "statusFilter");
        this.onResponseHeaders((ctx, headers) -> statusFilter.test((ClientRequestContext)ctx, headers.status()));
        return this.self();
    }

    public SELF onException(Class<? extends Throwable> exception) {
        Objects.requireNonNull(exception, "exception");
        return this.onException((? super ClientRequestContext unused, ? super Throwable ex) -> exception.isInstance(ex));
    }

    public SELF onException(BiPredicate<? super ClientRequestContext, ? super Throwable> exceptionFilter) {
        this.exceptionFilter = AbstractRuleBuilder.combinePredicates(this.exceptionFilter, exceptionFilter, "exceptionFilter");
        return this.self();
    }

    public SELF onException() {
        return this.onException((? super ClientRequestContext unused1, ? super Throwable unused2) -> true);
    }

    public SELF onTimeoutException() {
        return this.onException((? super ClientRequestContext ctx, ? super Throwable ex) -> {
            if (ctx.isTimedOut()) {
                return true;
            }
            return TimeoutExceptionPredicate.isTimeoutException(ex);
        });
    }

    private static <T> BiPredicate<ClientRequestContext, T> combinePredicates(@Nullable BiPredicate<ClientRequestContext, T> firstPredicate, BiPredicate<? super ClientRequestContext, ? super T> secondPredicate, String paramName) {
        Objects.requireNonNull(secondPredicate, paramName);
        if (firstPredicate != null) {
            return firstPredicate.or(secondPredicate);
        }
        BiPredicate<? super ClientRequestContext, ? super T> cast = secondPredicate;
        return cast;
    }

    public SELF onUnprocessed() {
        return this.onException(UnprocessedRequestException.class);
    }

    public SELF onTotalDuration(BiPredicate<? super ClientRequestContext, ? super Duration> totalDurationFilter) {
        this.totalDurationFilter = AbstractRuleBuilder.combinePredicates(this.totalDurationFilter, totalDurationFilter, "totalDurationFilter");
        return this.self();
    }

    protected final BiPredicate<ClientRequestContext, RequestHeaders> requestHeadersFilter() {
        return this.requestHeadersFilter;
    }

    @Nullable
    protected final BiPredicate<ClientRequestContext, ResponseHeaders> responseHeadersFilter() {
        return this.responseHeadersFilter;
    }

    @Nullable
    protected final BiPredicate<ClientRequestContext, HttpHeaders> responseTrailersFilter() {
        return this.responseTrailersFilter;
    }

    @Nullable
    protected final BiPredicate<ClientRequestContext, Throwable> exceptionFilter() {
        return this.exceptionFilter;
    }

    @Nullable
    protected final BiPredicate<ClientRequestContext, HttpHeaders> grpcTrailersFilter() {
        return this.grpcTrailersFilter;
    }

    @Nullable
    protected final BiPredicate<ClientRequestContext, Duration> totalDurationFilter() {
        return this.totalDurationFilter;
    }

    protected final boolean requiresResponseTrailers() {
        return this.responseTrailersFilter != null || this.grpcTrailersFilter != null || this.totalDurationFilter != null;
    }
}

