/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.client;

import io.opentelemetry.testing.internal.armeria.client.DefaultDnsQueryLifecycleObserverFactory;
import io.opentelemetry.testing.internal.armeria.client.DnsCache;
import io.opentelemetry.testing.internal.armeria.client.NoopHostFileEntriesResolver;
import io.opentelemetry.testing.internal.armeria.common.Flags;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.annotation.UnstableApi;
import io.opentelemetry.testing.internal.armeria.common.metric.MeterIdPrefix;
import io.opentelemetry.testing.internal.armeria.common.util.TransportType;
import io.opentelemetry.testing.internal.armeria.internal.client.dns.DnsUtil;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.MoreObjects;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.Preconditions;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableList;
import io.opentelemetry.testing.internal.io.micrometer.core.instrument.MeterRegistry;
import io.opentelemetry.testing.internal.io.netty.channel.EventLoopGroup;
import io.opentelemetry.testing.internal.io.netty.channel.socket.SocketChannel;
import io.opentelemetry.testing.internal.io.netty.resolver.HostsFileEntriesResolver;
import io.opentelemetry.testing.internal.io.netty.resolver.dns.BiDnsQueryLifecycleObserverFactory;
import io.opentelemetry.testing.internal.io.netty.resolver.dns.DnsNameResolverBuilder;
import io.opentelemetry.testing.internal.io.netty.resolver.dns.DnsNameResolverChannelStrategy;
import io.opentelemetry.testing.internal.io.netty.resolver.dns.DnsQueryLifecycleObserverFactory;
import io.opentelemetry.testing.internal.io.netty.resolver.dns.DnsServerAddressStreamProvider;
import io.opentelemetry.testing.internal.io.netty.resolver.dns.DnsServerAddressStreamProviders;
import io.opentelemetry.testing.internal.io.netty.resolver.dns.DnsServerAddresses;
import io.opentelemetry.testing.internal.io.netty.resolver.dns.NoopAuthoritativeDnsServerCache;
import io.opentelemetry.testing.internal.io.netty.resolver.dns.NoopDnsCache;
import io.opentelemetry.testing.internal.io.netty.resolver.dns.NoopDnsCnameCache;
import java.net.InetSocketAddress;
import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

@UnstableApi
public abstract class AbstractDnsResolverBuilder<SELF extends AbstractDnsResolverBuilder<SELF>> {
    private DnsCache dnsCache = DnsCache.ofDefault();
    private String cacheSpec = Flags.dnsCacheSpec();
    private int minTtl = 1;
    private int maxTtl = Integer.MAX_VALUE;
    private int negativeTtl;
    private boolean needsToCreateDnsCache;
    private boolean traceEnabled = true;
    private long queryTimeoutMillis = DnsUtil.defaultDnsQueryTimeoutMillis();
    private long queryTimeoutMillisForEachAttempt = -1L;
    private boolean recursionDesired = true;
    private int maxQueriesPerResolve = -1;
    private int maxPayloadSize = 4096;
    private boolean optResourceEnabled = true;
    private HostsFileEntriesResolver hostsFileEntriesResolver = HostsFileEntriesResolver.DEFAULT;
    private DnsServerAddressStreamProvider serverAddressStreamProvider = DnsServerAddressStreamProviders.platformDefault();
    @Nullable
    private DnsQueryLifecycleObserverFactory dnsQueryLifecycleObserverFactory;
    private boolean dnsQueryMetricsEnabled = true;
    private List<String> searchDomains = DnsUtil.defaultSearchDomains();
    private int ndots = DnsUtil.defaultNdots();
    private boolean decodeIdn = true;
    @Nullable
    private DnsNameResolverChannelStrategy datagramChannelStrategy;
    @Nullable
    private Class<? extends SocketChannel> socketChannelType;
    private boolean retrySocketChannelOnTimeout;
    @Nullable
    private MeterRegistry meterRegistry;

    protected AbstractDnsResolverBuilder() {
    }

    protected final SELF self() {
        return (SELF)this;
    }

    @Deprecated
    public SELF traceEnabled(boolean traceEnabled) {
        this.traceEnabled = traceEnabled;
        return this.self();
    }

    public SELF queryTimeout(Duration queryTimeout) {
        Objects.requireNonNull(queryTimeout, "queryTimeout");
        Preconditions.checkArgument(!queryTimeout.isNegative(), "queryTimeout: %s (expected: >= 0)", (Object)queryTimeout);
        return this.queryTimeoutMillis(queryTimeout.toMillis());
    }

    protected final long queryTimeoutMillis() {
        return this.queryTimeoutMillis;
    }

    public SELF queryTimeoutMillis(long queryTimeoutMillis) {
        Preconditions.checkArgument(queryTimeoutMillis >= 0L, "queryTimeoutMillis: %s (expected: >= 0)", queryTimeoutMillis);
        this.queryTimeoutMillis = queryTimeoutMillis;
        return this.self();
    }

    public SELF queryTimeoutForEachAttempt(Duration queryTimeoutForEachAttempt) {
        Objects.requireNonNull(queryTimeoutForEachAttempt, "queryTimeoutForEachAttempt");
        long queryTimeoutMillisForEachAttempt = queryTimeoutForEachAttempt.toMillis();
        Preconditions.checkArgument(queryTimeoutMillisForEachAttempt > 0L, "queryTimeoutForEachAttempt: %s (expected: > 0)", (Object)queryTimeoutForEachAttempt);
        return this.queryTimeoutMillisForEachAttempt(queryTimeoutMillisForEachAttempt);
    }

    public SELF queryTimeoutMillisForEachAttempt(long queryTimeoutMillisForEachAttempt) {
        Preconditions.checkArgument(queryTimeoutMillisForEachAttempt > 0L, "queryTimeoutMillisForEachAttempt: %s (expected: > 0)", queryTimeoutMillisForEachAttempt);
        this.queryTimeoutMillisForEachAttempt = queryTimeoutMillisForEachAttempt;
        return this.self();
    }

    public SELF recursionDesired(boolean recursionDesired) {
        this.recursionDesired = recursionDesired;
        return this.self();
    }

    public SELF maxQueriesPerResolve(int maxQueriesPerResolve) {
        Preconditions.checkArgument(maxQueriesPerResolve > 0, "maxQueriesPerResolve: %s (expected: > 0)", maxQueriesPerResolve);
        this.maxQueriesPerResolve = maxQueriesPerResolve;
        return this.self();
    }

    public SELF serverAddresses(InetSocketAddress ... serverAddresses) {
        return this.serverAddresses(ImmutableList.copyOf(Objects.requireNonNull(serverAddresses, "serverAddresses")));
    }

    public SELF serverAddresses(Iterable<InetSocketAddress> serverAddresses) {
        DnsServerAddresses addrs = DnsServerAddresses.sequential(serverAddresses);
        return this.serverAddressStreamProvider(hostname -> addrs.stream());
    }

    protected final DnsServerAddressStreamProvider serverAddressStreamProvider() {
        return this.serverAddressStreamProvider;
    }

    public SELF serverAddressStreamProvider(DnsServerAddressStreamProvider serverAddressStreamProvider) {
        Objects.requireNonNull(serverAddressStreamProvider, "serverAddressStreamProvider");
        this.serverAddressStreamProvider = serverAddressStreamProvider;
        return this.self();
    }

    @Deprecated
    public SELF dnsServerAddressStreamProvider(DnsServerAddressStreamProvider dnsServerAddressStreamProvider) {
        return this.serverAddressStreamProvider(dnsServerAddressStreamProvider);
    }

    public SELF maxPayloadSize(int maxPayloadSize) {
        Preconditions.checkArgument(maxPayloadSize > 0, "maxPayloadSize: %s (expected: > 0)", maxPayloadSize);
        this.maxPayloadSize = maxPayloadSize;
        return this.self();
    }

    public SELF optResourceEnabled(boolean optResourceEnabled) {
        this.optResourceEnabled = optResourceEnabled;
        return this.self();
    }

    protected final HostsFileEntriesResolver hostsFileEntriesResolver() {
        return this.hostsFileEntriesResolver;
    }

    public SELF hostsFileEntriesResolver(HostsFileEntriesResolver hostsFileEntriesResolver) {
        this.hostsFileEntriesResolver = hostsFileEntriesResolver;
        return this.self();
    }

    public SELF dnsQueryLifecycleObserverFactory(DnsQueryLifecycleObserverFactory observerFactory) {
        Objects.requireNonNull(observerFactory, "observerFactory");
        this.dnsQueryLifecycleObserverFactory = observerFactory;
        return this.self();
    }

    @Deprecated
    public SELF disableDnsQueryMetrics() {
        return this.enableDnsQueryMetrics(false);
    }

    public SELF enableDnsQueryMetrics(boolean enable) {
        this.dnsQueryMetricsEnabled = enable;
        return this.self();
    }

    protected final List<String> searchDomains() {
        return this.searchDomains;
    }

    public SELF searchDomains(String ... searchDomains) {
        Objects.requireNonNull(searchDomains, "searchDomains");
        return this.searchDomains(ImmutableList.copyOf(searchDomains));
    }

    public SELF searchDomains(Iterable<String> searchDomains) {
        Objects.requireNonNull(searchDomains, "searchDomains");
        this.searchDomains = ImmutableList.copyOf(searchDomains);
        return this.self();
    }

    protected final int ndots() {
        return this.ndots;
    }

    public SELF ndots(int ndots) {
        Preconditions.checkArgument(ndots >= 0, "ndots: %s (expected: >= 0)", ndots);
        this.ndots = ndots;
        return this.self();
    }

    public SELF decodeIdn(boolean decodeIdn) {
        this.decodeIdn = decodeIdn;
        return this.self();
    }

    @Nullable
    protected final MeterRegistry meterRegistry() {
        return this.meterRegistry;
    }

    public SELF meterRegistry(MeterRegistry meterRegistry) {
        this.meterRegistry = meterRegistry;
        return this.self();
    }

    protected final String cacheSpec() {
        return this.cacheSpec;
    }

    public SELF cacheSpec(String cacheSpec) {
        Objects.requireNonNull(cacheSpec, "cacheSpec");
        this.cacheSpec = cacheSpec;
        this.needsToCreateDnsCache = true;
        return this.self();
    }

    protected final int minTtl() {
        return this.minTtl;
    }

    protected final int maxTtl() {
        return this.maxTtl;
    }

    public SELF ttl(int minTtl, int maxTtl) {
        Preconditions.checkArgument(minTtl > 0 && minTtl <= maxTtl, "minTtl: %s, maxTtl: %s (expected: 1 <= minTtl <= maxTtl)", minTtl, maxTtl);
        this.minTtl = minTtl;
        this.maxTtl = maxTtl;
        this.needsToCreateDnsCache = true;
        return this.self();
    }

    protected final int negativeTtl() {
        return this.negativeTtl;
    }

    public SELF negativeTtl(int negativeTtl) {
        Preconditions.checkArgument(negativeTtl >= 0, "negativeTtl: %s (expected: >= 0)", negativeTtl);
        this.needsToCreateDnsCache = true;
        this.negativeTtl = negativeTtl;
        return this.self();
    }

    @UnstableApi
    public SELF dnsCache(DnsCache dnsCache) {
        Objects.requireNonNull(dnsCache, "dnsCache");
        this.dnsCache = dnsCache;
        return this.self();
    }

    @UnstableApi
    protected final DnsCache maybeCreateDnsCache() {
        if (this.needsToCreateDnsCache && this.dnsCache != DnsCache.ofDefault()) {
            throw new IllegalStateException("Cannot set dnsCache() with cacheSpec(), ttl(), or negativeTtl().");
        }
        MeterRegistry meterRegistry = MoreObjects.firstNonNull(this.meterRegistry, Flags.meterRegistry());
        if (this.needsToCreateDnsCache) {
            return DnsCache.builder().cacheSpec(this.cacheSpec).ttl(this.minTtl, this.maxTtl).negativeTtl(this.negativeTtl).meterRegistry(meterRegistry).build();
        }
        return this.dnsCache;
    }

    @UnstableApi
    public SELF datagramChannelStrategy(DnsNameResolverChannelStrategy datagramChannelStrategy) {
        Objects.requireNonNull(datagramChannelStrategy, "datagramChannelStrategy");
        this.datagramChannelStrategy = datagramChannelStrategy;
        return this.self();
    }

    @UnstableApi
    public SELF socketChannelType(Class<? extends SocketChannel> socketChannelType, boolean retrySocketChannelOnTimeout) {
        Objects.requireNonNull(socketChannelType, "channelType");
        this.socketChannelType = socketChannelType;
        this.retrySocketChannelOnTimeout = retrySocketChannelOnTimeout;
        return this.self();
    }

    @UnstableApi
    protected final Consumer<DnsNameResolverBuilder> buildConfigurator(EventLoopGroup eventLoopGroup) {
        if (this.queryTimeoutMillisForEachAttempt > -1L) {
            Preconditions.checkState(this.queryTimeoutMillis >= this.queryTimeoutMillisForEachAttempt, "queryTimeoutMillis: %s, queryTimeoutMillisForEachAttempt: %s (expected: queryTimeoutMillis >= queryTimeoutMillisForEachAttempt)", this.queryTimeoutMillis, this.queryTimeoutMillisForEachAttempt);
        }
        MeterRegistry meterRegistry = MoreObjects.firstNonNull(this.meterRegistry, Flags.meterRegistry());
        boolean traceEnabled = this.traceEnabled;
        long queryTimeoutMillis = this.queryTimeoutMillis;
        long queryTimeoutMillisForEachAttempt = this.queryTimeoutMillisForEachAttempt;
        boolean recursionDesired = this.recursionDesired;
        int maxQueriesPerResolve = this.maxQueriesPerResolve;
        int maxPayloadSize = this.maxPayloadSize;
        boolean optResourceEnabled = this.optResourceEnabled;
        DnsServerAddressStreamProvider serverAddressStreamProvider = this.serverAddressStreamProvider;
        DnsQueryLifecycleObserverFactory dnsQueryLifecycleObserverFactory = this.dnsQueryLifecycleObserverFactory;
        boolean dnsQueryMetricsEnabled = this.dnsQueryMetricsEnabled;
        boolean decodeIdn = this.decodeIdn;
        Class<? extends SocketChannel> socketChannelType = this.socketChannelType;
        if (socketChannelType == null) {
            socketChannelType = TransportType.socketChannelType(eventLoopGroup);
        }
        Class<? extends SocketChannel> finalSocketChannelType = socketChannelType;
        return builder -> {
            DnsNameResolverChannelStrategy datagramChannelStrategy;
            builder.datagramChannelType(TransportType.datagramChannelType(eventLoopGroup)).socketChannelType(finalSocketChannelType, this.retrySocketChannelOnTimeout).resolveCache(NoopDnsCache.INSTANCE).authoritativeDnsServerCache(NoopAuthoritativeDnsServerCache.INSTANCE).cnameCache(NoopDnsCnameCache.INSTANCE).traceEnabled(traceEnabled).completeOncePreferredResolved(true).recursionDesired(recursionDesired).maxQueriesPerResolve(maxQueriesPerResolve).maxPayloadSize(maxPayloadSize).optResourceEnabled(optResourceEnabled).hostsFileEntriesResolver(NoopHostFileEntriesResolver.INSTANCE).nameServerProvider(serverAddressStreamProvider).searchDomains(ImmutableList.of()).decodeIdn(decodeIdn);
            if (queryTimeoutMillisForEachAttempt > 0L && queryTimeoutMillisForEachAttempt < Long.MAX_VALUE) {
                builder.queryTimeoutMillis(queryTimeoutMillisForEachAttempt);
            } else if (queryTimeoutMillis == 0L || queryTimeoutMillis == Long.MAX_VALUE) {
                builder.queryTimeoutMillis(0L);
            } else {
                builder.queryTimeoutMillis(queryTimeoutMillis);
            }
            DnsQueryLifecycleObserverFactory observerFactory = dnsQueryLifecycleObserverFactory;
            if (dnsQueryMetricsEnabled) {
                DefaultDnsQueryLifecycleObserverFactory defaultObserverFactory = new DefaultDnsQueryLifecycleObserverFactory(meterRegistry, new MeterIdPrefix("armeria.client.dns.queries"));
                observerFactory = observerFactory == null ? defaultObserverFactory : new BiDnsQueryLifecycleObserverFactory(observerFactory, defaultObserverFactory);
            }
            if (observerFactory != null) {
                builder.dnsQueryLifecycleObserverFactory(observerFactory);
            }
            if ((datagramChannelStrategy = this.datagramChannelStrategy) != null) {
                builder.datagramChannelStrategy(datagramChannelStrategy);
            }
        };
    }
}

