/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.apachehttp.core5.http.nio.ssl;

import io.opentelemetry.testing.internal.apachehttp.core5.http.ssl.TLS;
import io.opentelemetry.testing.internal.apachehttp.core5.http.ssl.TlsCiphers;
import io.opentelemetry.testing.internal.apachehttp.core5.net.NamedEndpoint;
import io.opentelemetry.testing.internal.apachehttp.core5.reactor.ssl.SSLSessionInitializer;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;

public final class TlsSupport {
    public static SSLSessionInitializer enforceStrongSecurity(final SSLSessionInitializer initializer) {
        return new SSLSessionInitializer(){

            @Override
            public void initialize(NamedEndpoint endpoint, SSLEngine sslEngine) {
                SSLParameters sslParameters = sslEngine.getSSLParameters();
                sslParameters.setProtocols(TLS.excludeWeak(sslParameters.getProtocols()));
                sslParameters.setCipherSuites(TlsCiphers.excludeWeak(sslParameters.getCipherSuites()));
                sslEngine.setSSLParameters(sslParameters);
                if (initializer != null) {
                    initializer.initialize(endpoint, sslEngine);
                }
            }
        };
    }
}

