/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.apachehttp.core5.http.io.support;

import io.opentelemetry.testing.internal.apachehttp.core5.annotation.Contract;
import io.opentelemetry.testing.internal.apachehttp.core5.annotation.ThreadingBehavior;
import io.opentelemetry.testing.internal.apachehttp.core5.http.ClassicHttpRequest;
import io.opentelemetry.testing.internal.apachehttp.core5.http.ClassicHttpResponse;
import io.opentelemetry.testing.internal.apachehttp.core5.http.HttpException;
import io.opentelemetry.testing.internal.apachehttp.core5.http.HttpRequestMapper;
import io.opentelemetry.testing.internal.apachehttp.core5.http.HttpResponseFactory;
import io.opentelemetry.testing.internal.apachehttp.core5.http.impl.io.DefaultClassicHttpResponseFactory;
import io.opentelemetry.testing.internal.apachehttp.core5.http.io.HttpFilterChain;
import io.opentelemetry.testing.internal.apachehttp.core5.http.io.HttpFilterHandler;
import io.opentelemetry.testing.internal.apachehttp.core5.http.io.HttpRequestHandler;
import io.opentelemetry.testing.internal.apachehttp.core5.http.protocol.HttpContext;
import io.opentelemetry.testing.internal.apachehttp.core5.util.Args;
import java.io.IOException;

@Contract(threading=ThreadingBehavior.STATELESS)
public final class TerminalServerFilter
implements HttpFilterHandler {
    private final HttpRequestMapper<HttpRequestHandler> handlerMapper;
    private final HttpResponseFactory<ClassicHttpResponse> responseFactory;

    public TerminalServerFilter(HttpRequestMapper<HttpRequestHandler> handlerMapper, HttpResponseFactory<ClassicHttpResponse> responseFactory) {
        this.handlerMapper = Args.notNull(handlerMapper, "Handler mapper");
        this.responseFactory = responseFactory != null ? responseFactory : DefaultClassicHttpResponseFactory.INSTANCE;
    }

    @Override
    public void handle(ClassicHttpRequest request, HttpFilterChain.ResponseTrigger responseTrigger, HttpContext context, HttpFilterChain chain) throws HttpException, IOException {
        ClassicHttpResponse response = this.responseFactory.newHttpResponse(200);
        HttpRequestHandler handler = this.handlerMapper.resolve(request, context);
        if (handler != null) {
            handler.handle(request, response, context);
        } else {
            response.setCode(501);
        }
        responseTrigger.submitResponse(response);
    }
}

