/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.apachehttp.core5.http.impl.bootstrap;

import io.opentelemetry.testing.internal.apachehttp.core5.annotation.Internal;
import io.opentelemetry.testing.internal.apachehttp.core5.concurrent.DefaultThreadFactory;
import io.opentelemetry.testing.internal.apachehttp.core5.concurrent.FutureCallback;
import io.opentelemetry.testing.internal.apachehttp.core5.function.Callback;
import io.opentelemetry.testing.internal.apachehttp.core5.function.Decorator;
import io.opentelemetry.testing.internal.apachehttp.core5.function.Resolver;
import io.opentelemetry.testing.internal.apachehttp.core5.http.HttpHost;
import io.opentelemetry.testing.internal.apachehttp.core5.http.impl.DefaultAddressResolver;
import io.opentelemetry.testing.internal.apachehttp.core5.http.impl.bootstrap.AbstractConnectionInitiatorBase;
import io.opentelemetry.testing.internal.apachehttp.core5.io.CloseMode;
import io.opentelemetry.testing.internal.apachehttp.core5.reactor.ConnectionInitiator;
import io.opentelemetry.testing.internal.apachehttp.core5.reactor.DefaultConnectingIOReactor;
import io.opentelemetry.testing.internal.apachehttp.core5.reactor.IOEventHandlerFactory;
import io.opentelemetry.testing.internal.apachehttp.core5.reactor.IOReactorConfig;
import io.opentelemetry.testing.internal.apachehttp.core5.reactor.IOReactorService;
import io.opentelemetry.testing.internal.apachehttp.core5.reactor.IOReactorStatus;
import io.opentelemetry.testing.internal.apachehttp.core5.reactor.IOSession;
import io.opentelemetry.testing.internal.apachehttp.core5.reactor.IOSessionListener;
import io.opentelemetry.testing.internal.apachehttp.core5.util.Args;
import io.opentelemetry.testing.internal.apachehttp.core5.util.TimeValue;
import io.opentelemetry.testing.internal.apachehttp.core5.util.Timeout;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.concurrent.Future;

public class AsyncRequester
extends AbstractConnectionInitiatorBase
implements IOReactorService {
    private final DefaultConnectingIOReactor ioReactor;
    private final Resolver<HttpHost, InetSocketAddress> addressResolver;

    @Internal
    public AsyncRequester(IOEventHandlerFactory eventHandlerFactory, IOReactorConfig ioReactorConfig, Decorator<IOSession> ioSessionDecorator, Callback<Exception> exceptionCallback, IOSessionListener sessionListener, Callback<IOSession> sessionShutdownCallback, Resolver<HttpHost, InetSocketAddress> addressResolver) {
        this.ioReactor = new DefaultConnectingIOReactor(eventHandlerFactory, ioReactorConfig, new DefaultThreadFactory("requester-dispatch", true), ioSessionDecorator, exceptionCallback, sessionListener, sessionShutdownCallback);
        this.addressResolver = addressResolver != null ? addressResolver : DefaultAddressResolver.INSTANCE;
    }

    @Override
    ConnectionInitiator getIOReactor() {
        return this.ioReactor;
    }

    public Future<IOSession> requestSession(HttpHost host, Timeout timeout, Object attachment, FutureCallback<IOSession> callback) {
        Args.notNull(host, "Host");
        Args.notNull(timeout, "Timeout");
        return this.connect(host, this.addressResolver.resolve(host), null, timeout, attachment, callback);
    }

    @Override
    public void start() {
        this.ioReactor.start();
    }

    @Override
    public IOReactorStatus getStatus() {
        return this.ioReactor.getStatus();
    }

    @Override
    public void initiateShutdown() {
        this.ioReactor.initiateShutdown();
    }

    @Override
    public void awaitShutdown(TimeValue waitTime) throws InterruptedException {
        this.ioReactor.awaitShutdown(waitTime);
    }

    @Override
    public void close(CloseMode closeMode) {
        this.ioReactor.close(closeMode);
    }

    @Override
    public void close() throws IOException {
        this.ioReactor.close();
    }
}

