/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.apachehttp.client5.http.impl.cookie;

import io.opentelemetry.testing.internal.apachehttp.client5.http.cookie.CommonCookieAttributeHandler;
import io.opentelemetry.testing.internal.apachehttp.client5.http.cookie.Cookie;
import io.opentelemetry.testing.internal.apachehttp.client5.http.cookie.CookieOrigin;
import io.opentelemetry.testing.internal.apachehttp.client5.http.cookie.MalformedCookieException;
import io.opentelemetry.testing.internal.apachehttp.client5.http.cookie.SetCookie;
import io.opentelemetry.testing.internal.apachehttp.client5.http.impl.cookie.AbstractCookieAttributeHandler;
import io.opentelemetry.testing.internal.apachehttp.core5.annotation.Contract;
import io.opentelemetry.testing.internal.apachehttp.core5.annotation.ThreadingBehavior;
import io.opentelemetry.testing.internal.apachehttp.core5.util.Args;

@Contract(threading=ThreadingBehavior.STATELESS)
public class BasicSecureHandler
extends AbstractCookieAttributeHandler
implements CommonCookieAttributeHandler {
    @Override
    public void parse(SetCookie cookie, String value) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        cookie.setSecure(true);
    }

    @Override
    public boolean match(Cookie cookie, CookieOrigin origin) {
        Args.notNull(cookie, "Cookie");
        Args.notNull(origin, "Cookie origin");
        return !cookie.isSecure() || origin.isSecure();
    }

    @Override
    public String getAttributeName() {
        return "secure";
    }
}

