/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.apachehttp.client5.http.impl.auth;

import io.opentelemetry.testing.internal.apachehttp.client5.http.DnsResolver;
import io.opentelemetry.testing.internal.apachehttp.client5.http.SystemDefaultDnsResolver;
import io.opentelemetry.testing.internal.apachehttp.client5.http.auth.AuthScheme;
import io.opentelemetry.testing.internal.apachehttp.client5.http.auth.AuthSchemeFactory;
import io.opentelemetry.testing.internal.apachehttp.client5.http.auth.KerberosConfig;
import io.opentelemetry.testing.internal.apachehttp.client5.http.impl.auth.KerberosScheme;
import io.opentelemetry.testing.internal.apachehttp.core5.annotation.Contract;
import io.opentelemetry.testing.internal.apachehttp.core5.annotation.Experimental;
import io.opentelemetry.testing.internal.apachehttp.core5.annotation.ThreadingBehavior;
import io.opentelemetry.testing.internal.apachehttp.core5.http.protocol.HttpContext;

@Contract(threading=ThreadingBehavior.STATELESS)
@Experimental
public class KerberosSchemeFactory
implements AuthSchemeFactory {
    public static final KerberosSchemeFactory DEFAULT = new KerberosSchemeFactory(KerberosConfig.DEFAULT, SystemDefaultDnsResolver.INSTANCE);
    private final KerberosConfig config;
    private final DnsResolver dnsResolver;

    public KerberosSchemeFactory(KerberosConfig config, DnsResolver dnsResolver) {
        this.config = config;
        this.dnsResolver = dnsResolver;
    }

    @Override
    public AuthScheme create(HttpContext context) {
        return new KerberosScheme(this.config, this.dnsResolver);
    }
}

