/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.apachehttp.client5.http.impl;

import io.opentelemetry.testing.internal.apachehttp.core5.annotation.Contract;
import io.opentelemetry.testing.internal.apachehttp.core5.annotation.ThreadingBehavior;
import io.opentelemetry.testing.internal.apachehttp.core5.concurrent.DefaultThreadFactory;
import io.opentelemetry.testing.internal.apachehttp.core5.pool.ConnPoolControl;
import io.opentelemetry.testing.internal.apachehttp.core5.util.Args;
import io.opentelemetry.testing.internal.apachehttp.core5.util.TimeValue;
import io.opentelemetry.testing.internal.apachehttp.core5.util.Timeout;
import java.util.concurrent.ThreadFactory;

@Contract(threading=ThreadingBehavior.SAFE_CONDITIONAL)
public final class IdleConnectionEvictor {
    private final ThreadFactory threadFactory;
    private final Thread thread;

    public IdleConnectionEvictor(final ConnPoolControl<?> connectionManager, ThreadFactory threadFactory, TimeValue sleepTime, final TimeValue maxIdleTime) {
        Args.notNull(connectionManager, "Connection manager");
        this.threadFactory = threadFactory != null ? threadFactory : new DefaultThreadFactory("idle-connection-evictor", true);
        final TimeValue localSleepTime = sleepTime != null ? sleepTime : TimeValue.ofSeconds(5L);
        this.thread = this.threadFactory.newThread(new Runnable(){

            @Override
            public void run() {
                try {
                    while (!Thread.currentThread().isInterrupted()) {
                        localSleepTime.sleep();
                        connectionManager.closeExpired();
                        if (maxIdleTime == null) continue;
                        connectionManager.closeIdle(maxIdleTime);
                    }
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    public IdleConnectionEvictor(ConnPoolControl<?> connectionManager, TimeValue sleepTime, TimeValue maxIdleTime) {
        this(connectionManager, null, sleepTime, maxIdleTime);
    }

    public IdleConnectionEvictor(ConnPoolControl<?> connectionManager, TimeValue maxIdleTime) {
        this(connectionManager, null, maxIdleTime, maxIdleTime);
    }

    public void start() {
        this.thread.start();
    }

    public void shutdown() {
        this.thread.interrupt();
    }

    public boolean isRunning() {
        return this.thread.isAlive();
    }

    public void awaitTermination(Timeout timeout) throws InterruptedException {
        this.thread.join(timeout != null ? timeout.toMilliseconds() : Long.MAX_VALUE);
    }
}

