/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.apachehttp.client5.http.classic;

import io.opentelemetry.testing.internal.apachehttp.client5.http.HttpRoute;
import io.opentelemetry.testing.internal.apachehttp.client5.http.classic.ExecRuntime;
import io.opentelemetry.testing.internal.apachehttp.client5.http.protocol.HttpClientContext;
import io.opentelemetry.testing.internal.apachehttp.core5.annotation.Contract;
import io.opentelemetry.testing.internal.apachehttp.core5.annotation.ThreadingBehavior;
import io.opentelemetry.testing.internal.apachehttp.core5.http.ClassicHttpRequest;
import io.opentelemetry.testing.internal.apachehttp.core5.http.ClassicHttpResponse;
import io.opentelemetry.testing.internal.apachehttp.core5.http.HttpException;
import io.opentelemetry.testing.internal.apachehttp.core5.util.Args;
import java.io.IOException;

@Contract(threading=ThreadingBehavior.STATELESS)
public interface ExecChain {
    public ClassicHttpResponse proceed(ClassicHttpRequest var1, Scope var2) throws IOException, HttpException;

    public static final class Scope {
        public final String exchangeId;
        public final HttpRoute route;
        public final ClassicHttpRequest originalRequest;
        public final ExecRuntime execRuntime;
        public final HttpClientContext clientContext;

        public Scope(String exchangeId, HttpRoute route, ClassicHttpRequest originalRequest, ExecRuntime execRuntime, HttpClientContext clientContext) {
            this.exchangeId = Args.notNull(exchangeId, "Exchange id");
            this.route = Args.notNull(route, "Route");
            this.originalRequest = Args.notNull(originalRequest, "Original request");
            this.execRuntime = Args.notNull(execRuntime, "Exec runtime");
            this.clientContext = clientContext != null ? clientContext : HttpClientContext.create();
        }
    }
}

