/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.testing.common;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.api.common.KeyValue;
import io.opentelemetry.api.common.Value;
import io.opentelemetry.api.incubator.common.ExtendedAttributes;
import io.opentelemetry.api.incubator.common.ExtendedAttributesBuilder;
import io.opentelemetry.api.logs.Severity;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.api.trace.TraceFlags;
import io.opentelemetry.api.trace.TraceState;
import io.opentelemetry.api.trace.TraceStateBuilder;
import io.opentelemetry.javaagent.testing.common.AgentClassLoaderAccess;
import io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import io.opentelemetry.sdk.logs.data.LogRecordData;
import io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import io.opentelemetry.sdk.metrics.data.DoublePointData;
import io.opentelemetry.sdk.metrics.data.GaugeData;
import io.opentelemetry.sdk.metrics.data.HistogramData;
import io.opentelemetry.sdk.metrics.data.HistogramPointData;
import io.opentelemetry.sdk.metrics.data.LongPointData;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.data.SumData;
import io.opentelemetry.sdk.metrics.data.SummaryData;
import io.opentelemetry.sdk.metrics.data.SummaryPointData;
import io.opentelemetry.sdk.metrics.data.ValueAtQuantile;
import io.opentelemetry.sdk.metrics.internal.data.ImmutableDoublePointData;
import io.opentelemetry.sdk.metrics.internal.data.ImmutableGaugeData;
import io.opentelemetry.sdk.metrics.internal.data.ImmutableHistogramData;
import io.opentelemetry.sdk.metrics.internal.data.ImmutableHistogramPointData;
import io.opentelemetry.sdk.metrics.internal.data.ImmutableLongPointData;
import io.opentelemetry.sdk.metrics.internal.data.ImmutableMetricData;
import io.opentelemetry.sdk.metrics.internal.data.ImmutableSumData;
import io.opentelemetry.sdk.metrics.internal.data.ImmutableSummaryData;
import io.opentelemetry.sdk.metrics.internal.data.ImmutableSummaryPointData;
import io.opentelemetry.sdk.metrics.internal.data.ImmutableValueAtQuantile;
import io.opentelemetry.sdk.testing.logs.TestLogRecordData;
import io.opentelemetry.sdk.testing.logs.internal.TestExtendedLogRecordData;
import io.opentelemetry.sdk.testing.trace.TestSpanData;
import io.opentelemetry.sdk.trace.data.EventData;
import io.opentelemetry.sdk.trace.data.LinkData;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.opentelemetry.sdk.trace.data.StatusData;
import io.opentelemetry.testing.internal.proto.collector.logs.v1.ExportLogsServiceRequest;
import io.opentelemetry.testing.internal.proto.collector.metrics.v1.ExportMetricsServiceRequest;
import io.opentelemetry.testing.internal.proto.collector.trace.v1.ExportTraceServiceRequest;
import io.opentelemetry.testing.internal.proto.common.v1.AnyValue;
import io.opentelemetry.testing.internal.proto.common.v1.ArrayValue;
import io.opentelemetry.testing.internal.proto.common.v1.InstrumentationScope;
import io.opentelemetry.testing.internal.proto.common.v1.KeyValueList;
import io.opentelemetry.testing.internal.proto.logs.v1.LogRecord;
import io.opentelemetry.testing.internal.proto.logs.v1.ResourceLogs;
import io.opentelemetry.testing.internal.proto.logs.v1.ScopeLogs;
import io.opentelemetry.testing.internal.proto.logs.v1.SeverityNumber;
import io.opentelemetry.testing.internal.proto.metrics.v1.HistogramDataPoint;
import io.opentelemetry.testing.internal.proto.metrics.v1.Metric;
import io.opentelemetry.testing.internal.proto.metrics.v1.NumberDataPoint;
import io.opentelemetry.testing.internal.proto.metrics.v1.ResourceMetrics;
import io.opentelemetry.testing.internal.proto.metrics.v1.ScopeMetrics;
import io.opentelemetry.testing.internal.proto.metrics.v1.Sum;
import io.opentelemetry.testing.internal.proto.metrics.v1.SummaryDataPoint;
import io.opentelemetry.testing.internal.proto.resource.v1.Resource;
import io.opentelemetry.testing.internal.proto.trace.v1.ResourceSpans;
import io.opentelemetry.testing.internal.proto.trace.v1.ScopeSpans;
import io.opentelemetry.testing.internal.proto.trace.v1.Span;
import io.opentelemetry.testing.internal.proto.trace.v1.Status;
import io.opentelemetry.testing.internal.protobuf.InvalidProtocolBufferException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public final class AgentTestingExporterAccess {
    private static final char TRACESTATE_KEY_VALUE_DELIMITER = '=';
    private static final char TRACESTATE_ENTRY_DELIMITER = ',';
    private static final Pattern TRACESTATE_ENTRY_DELIMITER_SPLIT_PATTERN = Pattern.compile("[ \t]*,[ \t]*");
    private static final MethodHandle getSpanExportRequests;
    private static final MethodHandle getMetricExportRequests;
    private static final MethodHandle getLogExportRequests;
    private static final MethodHandle reset;
    private static final MethodHandle forceFlushCalled;
    private static final boolean canUseValue;
    private static final boolean hasExtendedLogRecordData;
    private static final boolean hasExtendedAttributes;
    private static final String ALPHABET = "0123456789abcdef";
    private static final char[] ENCODING;

    private static boolean classAvailable(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static void reset() {
        try {
            reset.invokeExact();
        }
        catch (Throwable t) {
            throw new AssertionError("Could not invoke reset", t);
        }
    }

    public static boolean forceFlushCalled() {
        try {
            return forceFlushCalled.invokeExact();
        }
        catch (Throwable t) {
            throw new AssertionError("Could not invoke forceFlushCalled", t);
        }
    }

    public static List<SpanData> getExportedSpans() {
        List exportRequests;
        try {
            exportRequests = getSpanExportRequests.invokeExact();
        }
        catch (Throwable t) {
            throw new AssertionError("Could not invoke getSpanExportRequests", t);
        }
        List allResourceSpans = exportRequests.stream().map(serialized -> {
            try {
                return ExportTraceServiceRequest.parseFrom(serialized);
            }
            catch (InvalidProtocolBufferException e) {
                throw new AssertionError((Object)e);
            }
        }).flatMap(request -> request.getResourceSpansList().stream()).collect(Collectors.toList());
        ArrayList<SpanData> spans = new ArrayList<SpanData>();
        for (ResourceSpans resourceSpans : allResourceSpans) {
            Resource resource = resourceSpans.getResource();
            for (ScopeSpans ilSpans : resourceSpans.getScopeSpansList()) {
                InstrumentationScope instrumentationScope = ilSpans.getScope();
                for (Span span : ilSpans.getSpansList()) {
                    String traceId = AgentTestingExporterAccess.bytesToHex(span.getTraceId().toByteArray());
                    spans.add((SpanData)TestSpanData.builder().setSpanContext(SpanContext.create((String)traceId, (String)AgentTestingExporterAccess.bytesToHex(span.getSpanId().toByteArray()), (TraceFlags)TraceFlags.getDefault(), (TraceState)AgentTestingExporterAccess.extractTraceState(span.getTraceState()))).setParentSpanContext(SpanContext.create((String)traceId, (String)AgentTestingExporterAccess.bytesToHex(span.getParentSpanId().toByteArray()), (TraceFlags)TraceFlags.getDefault(), (TraceState)TraceState.getDefault())).setResource(io.opentelemetry.sdk.resources.Resource.create((Attributes)AgentTestingExporterAccess.fromProto(resource.getAttributesList()))).setInstrumentationScopeInfo(InstrumentationScopeInfo.builder((String)instrumentationScope.getName()).setVersion(AgentTestingExporterAccess.emptyToNull(instrumentationScope.getVersion())).build()).setName(span.getName()).setStartEpochNanos(span.getStartTimeUnixNano()).setEndEpochNanos(span.getEndTimeUnixNano()).setAttributes(AgentTestingExporterAccess.fromProto(span.getAttributesList())).setEvents(span.getEventsList().stream().map(event -> EventData.create((long)event.getTimeUnixNano(), (String)event.getName(), (Attributes)AgentTestingExporterAccess.fromProto(event.getAttributesList()), (int)(event.getDroppedAttributesCount() + event.getAttributesCount()))).collect(Collectors.toList())).setStatus(AgentTestingExporterAccess.fromProto(span.getStatus())).setKind(AgentTestingExporterAccess.fromProto(span.getKind())).setLinks(span.getLinksList().stream().map(link -> LinkData.create((SpanContext)SpanContext.create((String)AgentTestingExporterAccess.bytesToHex(link.getTraceId().toByteArray()), (String)AgentTestingExporterAccess.bytesToHex(link.getSpanId().toByteArray()), (TraceFlags)TraceFlags.getDefault(), (TraceState)AgentTestingExporterAccess.extractTraceState(link.getTraceState())), (Attributes)AgentTestingExporterAccess.fromProto(link.getAttributesList()), (int)(link.getDroppedAttributesCount() + link.getAttributesCount()))).collect(Collectors.toList())).setHasEnded(true).setTotalRecordedEvents(span.getEventsCount() + span.getDroppedEventsCount()).setTotalRecordedLinks(span.getLinksCount() + span.getDroppedLinksCount()).setTotalAttributeCount(span.getAttributesCount() + span.getDroppedAttributesCount()).build());
                }
            }
        }
        return spans;
    }

    public static List<MetricData> getExportedMetrics() {
        List exportRequests;
        try {
            exportRequests = getMetricExportRequests.invokeExact();
        }
        catch (Throwable t) {
            throw new AssertionError("Could not invoke getMetricExportRequests", t);
        }
        List allResourceMetrics = exportRequests.stream().map(serialized -> {
            try {
                return ExportMetricsServiceRequest.parseFrom(serialized);
            }
            catch (InvalidProtocolBufferException e) {
                throw new AssertionError((Object)e);
            }
        }).flatMap(request -> request.getResourceMetricsList().stream()).collect(Collectors.toList());
        ArrayList<MetricData> metrics = new ArrayList<MetricData>();
        for (ResourceMetrics resourceMetrics : allResourceMetrics) {
            Resource resource = resourceMetrics.getResource();
            for (ScopeMetrics ilMetrics : resourceMetrics.getScopeMetricsList()) {
                InstrumentationScope instrumentationScope = ilMetrics.getScope();
                for (Metric metric : ilMetrics.getMetricsList()) {
                    metrics.add(AgentTestingExporterAccess.createMetricData(metric, io.opentelemetry.sdk.resources.Resource.create((Attributes)AgentTestingExporterAccess.fromProto(resource.getAttributesList())), InstrumentationScopeInfo.builder((String)instrumentationScope.getName()).setVersion(AgentTestingExporterAccess.emptyToNull(instrumentationScope.getVersion())).build()));
                }
            }
        }
        return metrics;
    }

    public static List<LogRecordData> getExportedLogRecords() {
        List exportRequests;
        try {
            exportRequests = getLogExportRequests.invokeExact();
        }
        catch (Throwable t) {
            throw new AssertionError("Could not invoke getMetricExportRequests", t);
        }
        List allResourceLogs = exportRequests.stream().map(serialized -> {
            try {
                return ExportLogsServiceRequest.parseFrom(serialized);
            }
            catch (InvalidProtocolBufferException e) {
                throw new AssertionError((Object)e);
            }
        }).flatMap(request -> request.getResourceLogsList().stream()).collect(Collectors.toList());
        ArrayList<LogRecordData> logs = new ArrayList<LogRecordData>();
        for (ResourceLogs resourceLogs : allResourceLogs) {
            Resource resource = resourceLogs.getResource();
            for (ScopeLogs ilLogs : resourceLogs.getScopeLogsList()) {
                InstrumentationScope instrumentationScope = ilLogs.getScope();
                for (LogRecord logRecord : ilLogs.getLogRecordsList()) {
                    logs.add(AgentTestingExporterAccess.createLogData(logRecord, io.opentelemetry.sdk.resources.Resource.create((Attributes)AgentTestingExporterAccess.fromProto(resource.getAttributesList())), InstrumentationScopeInfo.builder((String)instrumentationScope.getName()).setVersion(AgentTestingExporterAccess.emptyToNull(instrumentationScope.getVersion())).build()));
                }
            }
        }
        return logs;
    }

    private static MetricData createMetricData(Metric metric, io.opentelemetry.sdk.resources.Resource resource, InstrumentationScopeInfo instrumentationScopeInfo) {
        switch (metric.getDataCase()) {
            case GAUGE: {
                if (AgentTestingExporterAccess.isDouble(metric.getGauge().getDataPointsList())) {
                    return ImmutableMetricData.createDoubleGauge((io.opentelemetry.sdk.resources.Resource)resource, (InstrumentationScopeInfo)instrumentationScopeInfo, (String)metric.getName(), (String)metric.getDescription(), (String)metric.getUnit(), (GaugeData)ImmutableGaugeData.create(AgentTestingExporterAccess.getDoublePointDatas(metric.getGauge().getDataPointsList())));
                }
                return ImmutableMetricData.createLongGauge((io.opentelemetry.sdk.resources.Resource)resource, (InstrumentationScopeInfo)instrumentationScopeInfo, (String)metric.getName(), (String)metric.getDescription(), (String)metric.getUnit(), (GaugeData)ImmutableGaugeData.create(AgentTestingExporterAccess.getLongPointDatas(metric.getGauge().getDataPointsList())));
            }
            case SUM: {
                if (AgentTestingExporterAccess.isDouble(metric.getSum().getDataPointsList())) {
                    Sum doubleSum = metric.getSum();
                    return ImmutableMetricData.createDoubleSum((io.opentelemetry.sdk.resources.Resource)resource, (InstrumentationScopeInfo)instrumentationScopeInfo, (String)metric.getName(), (String)metric.getDescription(), (String)metric.getUnit(), (SumData)ImmutableSumData.create((boolean)doubleSum.getIsMonotonic(), (AggregationTemporality)AgentTestingExporterAccess.getTemporality(doubleSum.getAggregationTemporality()), AgentTestingExporterAccess.getDoublePointDatas(metric.getSum().getDataPointsList())));
                }
                Sum longSum = metric.getSum();
                return ImmutableMetricData.createLongSum((io.opentelemetry.sdk.resources.Resource)resource, (InstrumentationScopeInfo)instrumentationScopeInfo, (String)metric.getName(), (String)metric.getDescription(), (String)metric.getUnit(), (SumData)ImmutableSumData.create((boolean)longSum.getIsMonotonic(), (AggregationTemporality)AgentTestingExporterAccess.getTemporality(longSum.getAggregationTemporality()), AgentTestingExporterAccess.getLongPointDatas(metric.getSum().getDataPointsList())));
            }
            case HISTOGRAM: {
                return ImmutableMetricData.createDoubleHistogram((io.opentelemetry.sdk.resources.Resource)resource, (InstrumentationScopeInfo)instrumentationScopeInfo, (String)metric.getName(), (String)metric.getDescription(), (String)metric.getUnit(), (HistogramData)ImmutableHistogramData.create((AggregationTemporality)AgentTestingExporterAccess.getTemporality(metric.getHistogram().getAggregationTemporality()), AgentTestingExporterAccess.getDoubleHistogramDataPoints(metric.getHistogram().getDataPointsList())));
            }
            case SUMMARY: {
                return ImmutableMetricData.createDoubleSummary((io.opentelemetry.sdk.resources.Resource)resource, (InstrumentationScopeInfo)instrumentationScopeInfo, (String)metric.getName(), (String)metric.getDescription(), (String)metric.getUnit(), (SummaryData)ImmutableSummaryData.create(AgentTestingExporterAccess.getDoubleSummaryDataPoints(metric.getSummary().getDataPointsList())));
            }
        }
        throw new AssertionError((Object)("Unexpected metric data: " + metric.getDataCase()));
    }

    private static LogRecordData createLogData(LogRecord logRecord, io.opentelemetry.sdk.resources.Resource resource, InstrumentationScopeInfo instrumentationScopeInfo) {
        if (hasExtendedLogRecordData) {
            return AgentTestingExporterAccess.createExtendedLogData(logRecord, resource, instrumentationScopeInfo);
        }
        TestLogRecordData.Builder builder = TestLogRecordData.builder().setResource(resource).setInstrumentationScopeInfo(instrumentationScopeInfo).setTimestamp(logRecord.getTimeUnixNano(), TimeUnit.NANOSECONDS).setSpanContext(SpanContext.create((String)AgentTestingExporterAccess.bytesToHex(logRecord.getTraceId().toByteArray()), (String)AgentTestingExporterAccess.bytesToHex(logRecord.getSpanId().toByteArray()), (TraceFlags)TraceFlags.getDefault(), (TraceState)TraceState.getDefault())).setSeverity(AgentTestingExporterAccess.fromProto(logRecord.getSeverityNumber())).setSeverityText(logRecord.getSeverityText()).setAttributes(AgentTestingExporterAccess.fromProto(logRecord.getAttributesList()));
        if (canUseValue) {
            builder.setBodyValue(AgentTestingExporterAccess.getBodyValue(logRecord.getBody()));
        } else {
            builder.setBody(logRecord.getBody().getStringValue());
        }
        return builder.build();
    }

    private static LogRecordData createExtendedLogData(LogRecord logRecord, io.opentelemetry.sdk.resources.Resource resource, InstrumentationScopeInfo instrumentationScopeInfo) {
        TestExtendedLogRecordData.Builder builder = TestExtendedLogRecordData.builder().setResource(resource).setInstrumentationScopeInfo(instrumentationScopeInfo).setTimestamp(logRecord.getTimeUnixNano(), TimeUnit.NANOSECONDS).setSpanContext(SpanContext.create((String)AgentTestingExporterAccess.bytesToHex(logRecord.getTraceId().toByteArray()), (String)AgentTestingExporterAccess.bytesToHex(logRecord.getSpanId().toByteArray()), (TraceFlags)TraceFlags.getDefault(), (TraceState)TraceState.getDefault())).setSeverity(AgentTestingExporterAccess.fromProto(logRecord.getSeverityNumber())).setSeverityText(logRecord.getSeverityText()).setEventName(logRecord.getEventName()).setBodyValue(AgentTestingExporterAccess.getBodyValue(logRecord.getBody()));
        if (hasExtendedAttributes) {
            builder.setExtendedAttributes(AgentTestingExporterAccess.fromProtoExtended(logRecord.getAttributesList()));
        } else {
            builder.setAttributes(AgentTestingExporterAccess.fromProto(logRecord.getAttributesList()));
        }
        return builder.build();
    }

    private static Value<?> getBodyValue(AnyValue value) {
        switch (value.getValueCase()) {
            case STRING_VALUE: {
                return Value.of((String)value.getStringValue());
            }
            case BOOL_VALUE: {
                return Value.of((boolean)value.getBoolValue());
            }
            case INT_VALUE: {
                return Value.of((long)value.getIntValue());
            }
            case DOUBLE_VALUE: {
                return Value.of((double)value.getDoubleValue());
            }
            case ARRAY_VALUE: {
                ArrayValue array = value.getArrayValue();
                ArrayList convertedValues = new ArrayList();
                for (int i = 0; i < array.getValuesCount(); ++i) {
                    convertedValues.add(AgentTestingExporterAccess.getBodyValue(array.getValues(i)));
                }
                return Value.of(convertedValues);
            }
            case KVLIST_VALUE: {
                KeyValueList keyValueList = value.getKvlistValue();
                KeyValue[] convertedKeyValueList = new KeyValue[keyValueList.getValuesCount()];
                for (int i = 0; i < keyValueList.getValuesCount(); ++i) {
                    io.opentelemetry.testing.internal.proto.common.v1.KeyValue keyValue = keyValueList.getValues(i);
                    convertedKeyValueList[i] = KeyValue.of((String)keyValue.getKey(), AgentTestingExporterAccess.getBodyValue(keyValue.getValue()));
                }
                return Value.of((KeyValue[])convertedKeyValueList);
            }
            case BYTES_VALUE: {
                return Value.of((byte[])value.getBytesValue().toByteArray());
            }
            case VALUE_NOT_SET: {
                return null;
            }
        }
        throw new IllegalStateException("Unexpected attribute: " + value.getValueCase());
    }

    private static boolean isDouble(List<NumberDataPoint> points) {
        if (points.isEmpty()) {
            return true;
        }
        return points.get(0).getValueCase() == NumberDataPoint.ValueCase.AS_DOUBLE;
    }

    private static List<DoublePointData> getDoublePointDatas(List<NumberDataPoint> points) {
        return points.stream().map(point -> {
            double value;
            switch (point.getValueCase()) {
                case AS_INT: {
                    value = point.getAsInt();
                    break;
                }
                default: {
                    value = point.getAsDouble();
                }
            }
            return ImmutableDoublePointData.create((long)point.getStartTimeUnixNano(), (long)point.getTimeUnixNano(), (Attributes)AgentTestingExporterAccess.fromProto(point.getAttributesList()), (double)value);
        }).collect(Collectors.toList());
    }

    private static List<LongPointData> getLongPointDatas(List<NumberDataPoint> points) {
        return points.stream().map(point -> {
            long value;
            switch (point.getValueCase()) {
                case AS_INT: {
                    value = point.getAsInt();
                    break;
                }
                default: {
                    value = (long)point.getAsDouble();
                }
            }
            return ImmutableLongPointData.create((long)point.getStartTimeUnixNano(), (long)point.getTimeUnixNano(), (Attributes)AgentTestingExporterAccess.fromProto(point.getAttributesList()), (long)value);
        }).collect(Collectors.toList());
    }

    private static Collection<HistogramPointData> getDoubleHistogramDataPoints(List<HistogramDataPoint> dataPointsList) {
        return dataPointsList.stream().map(point -> ImmutableHistogramPointData.create((long)point.getStartTimeUnixNano(), (long)point.getTimeUnixNano(), (Attributes)AgentTestingExporterAccess.fromProto(point.getAttributesList()), (double)point.getSum(), (boolean)point.hasMin(), (double)point.getMin(), (boolean)point.hasMax(), (double)point.getMax(), point.getExplicitBoundsList(), point.getBucketCountsList())).collect(Collectors.toList());
    }

    private static Collection<SummaryPointData> getDoubleSummaryDataPoints(List<SummaryDataPoint> dataPointsList) {
        return dataPointsList.stream().map(point -> ImmutableSummaryPointData.create((long)point.getStartTimeUnixNano(), (long)point.getTimeUnixNano(), (Attributes)AgentTestingExporterAccess.fromProto(point.getAttributesList()), (long)point.getCount(), (double)point.getSum(), AgentTestingExporterAccess.getValues(point))).collect(Collectors.toList());
    }

    private static List<ValueAtQuantile> getValues(SummaryDataPoint point) {
        return point.getQuantileValuesList().stream().map(v -> ImmutableValueAtQuantile.create((double)v.getQuantile(), (double)v.getValue())).collect(Collectors.toList());
    }

    private static AggregationTemporality getTemporality(io.opentelemetry.testing.internal.proto.metrics.v1.AggregationTemporality aggregationTemporality) {
        switch (aggregationTemporality) {
            case AGGREGATION_TEMPORALITY_CUMULATIVE: {
                return AggregationTemporality.CUMULATIVE;
            }
            case AGGREGATION_TEMPORALITY_DELTA: {
                return AggregationTemporality.DELTA;
            }
        }
        throw new IllegalStateException("Unexpected aggregation temporality: " + aggregationTemporality);
    }

    private static ExtendedAttributes fromProtoExtended(List<io.opentelemetry.testing.internal.proto.common.v1.KeyValue> attributes) {
        ExtendedAttributesBuilder converted = ExtendedAttributes.builder();
        block16: for (io.opentelemetry.testing.internal.proto.common.v1.KeyValue attribute : attributes) {
            String key = attribute.getKey();
            AnyValue value = attribute.getValue();
            switch (value.getValueCase()) {
                case STRING_VALUE: {
                    converted.put(key, value.getStringValue());
                    continue block16;
                }
                case BOOL_VALUE: {
                    converted.put(key, value.getBoolValue());
                    continue block16;
                }
                case INT_VALUE: {
                    converted.put(key, value.getIntValue());
                    continue block16;
                }
                case DOUBLE_VALUE: {
                    converted.put(key, value.getDoubleValue());
                    continue block16;
                }
                case ARRAY_VALUE: {
                    ArrayValue array = value.getArrayValue();
                    if (array.getValuesCount() == 0) continue block16;
                    switch (array.getValues(0).getValueCase()) {
                        case STRING_VALUE: {
                            converted.put(AttributeKey.stringArrayKey((String)key), array.getValuesList().stream().map(AnyValue::getStringValue).collect(Collectors.toList()));
                            continue block16;
                        }
                        case BOOL_VALUE: {
                            converted.put(AttributeKey.booleanArrayKey((String)key), array.getValuesList().stream().map(AnyValue::getBoolValue).collect(Collectors.toList()));
                            continue block16;
                        }
                        case INT_VALUE: {
                            converted.put(AttributeKey.longArrayKey((String)key), array.getValuesList().stream().map(AnyValue::getIntValue).collect(Collectors.toList()));
                            continue block16;
                        }
                        case DOUBLE_VALUE: {
                            converted.put(AttributeKey.doubleArrayKey((String)key), array.getValuesList().stream().map(AnyValue::getDoubleValue).collect(Collectors.toList()));
                            continue block16;
                        }
                        case VALUE_NOT_SET: {
                            continue block16;
                        }
                    }
                    throw new IllegalStateException("Unexpected attribute: " + array.getValues(0).getValueCase());
                }
                case KVLIST_VALUE: {
                    converted.put(key, AgentTestingExporterAccess.fromProtoExtended(value.getKvlistValue().getValuesList()));
                    continue block16;
                }
                case VALUE_NOT_SET: {
                    continue block16;
                }
            }
            throw new IllegalStateException("Unexpected attribute: " + value.getValueCase());
        }
        return converted.build();
    }

    private static Attributes fromProto(List<io.opentelemetry.testing.internal.proto.common.v1.KeyValue> attributes) {
        AttributesBuilder converted = Attributes.builder();
        block15: for (io.opentelemetry.testing.internal.proto.common.v1.KeyValue attribute : attributes) {
            String key = attribute.getKey();
            AnyValue value = attribute.getValue();
            switch (value.getValueCase()) {
                case STRING_VALUE: {
                    converted.put(key, value.getStringValue());
                    continue block15;
                }
                case BOOL_VALUE: {
                    converted.put(key, value.getBoolValue());
                    continue block15;
                }
                case INT_VALUE: {
                    converted.put(key, value.getIntValue());
                    continue block15;
                }
                case DOUBLE_VALUE: {
                    converted.put(key, value.getDoubleValue());
                    continue block15;
                }
                case ARRAY_VALUE: {
                    ArrayValue array = value.getArrayValue();
                    if (array.getValuesCount() == 0) continue block15;
                    switch (array.getValues(0).getValueCase()) {
                        case STRING_VALUE: {
                            converted.put(AttributeKey.stringArrayKey((String)key), array.getValuesList().stream().map(AnyValue::getStringValue).collect(Collectors.toList()));
                            continue block15;
                        }
                        case BOOL_VALUE: {
                            converted.put(AttributeKey.booleanArrayKey((String)key), array.getValuesList().stream().map(AnyValue::getBoolValue).collect(Collectors.toList()));
                            continue block15;
                        }
                        case INT_VALUE: {
                            converted.put(AttributeKey.longArrayKey((String)key), array.getValuesList().stream().map(AnyValue::getIntValue).collect(Collectors.toList()));
                            continue block15;
                        }
                        case DOUBLE_VALUE: {
                            converted.put(AttributeKey.doubleArrayKey((String)key), array.getValuesList().stream().map(AnyValue::getDoubleValue).collect(Collectors.toList()));
                            continue block15;
                        }
                        case VALUE_NOT_SET: {
                            continue block15;
                        }
                    }
                    throw new IllegalStateException("Unexpected attribute: " + array.getValues(0).getValueCase());
                }
                case VALUE_NOT_SET: {
                    continue block15;
                }
            }
            throw new IllegalStateException("Unexpected attribute: " + value.getValueCase());
        }
        return converted.build();
    }

    private static StatusData fromProto(Status status) {
        StatusCode code;
        switch (status.getCode()) {
            case STATUS_CODE_OK: {
                code = StatusCode.OK;
                break;
            }
            case STATUS_CODE_ERROR: {
                code = StatusCode.ERROR;
                break;
            }
            default: {
                code = StatusCode.UNSET;
            }
        }
        return StatusData.create((StatusCode)code, (String)status.getMessage());
    }

    private static SpanKind fromProto(Span.SpanKind kind) {
        switch (kind) {
            case SPAN_KIND_INTERNAL: {
                return SpanKind.INTERNAL;
            }
            case SPAN_KIND_SERVER: {
                return SpanKind.SERVER;
            }
            case SPAN_KIND_CLIENT: {
                return SpanKind.CLIENT;
            }
            case SPAN_KIND_PRODUCER: {
                return SpanKind.PRODUCER;
            }
            case SPAN_KIND_CONSUMER: {
                return SpanKind.CONSUMER;
            }
        }
        throw new IllegalArgumentException("Unexpected span kind: " + kind);
    }

    private static Severity fromProto(SeverityNumber proto) {
        for (Severity severity : Severity.values()) {
            if (severity.getSeverityNumber() != proto.getNumber()) continue;
            return severity;
        }
        throw new IllegalArgumentException("Unexpected SeverityNumber: " + proto);
    }

    private static TraceState extractTraceState(String traceStateHeader) {
        if (traceStateHeader.isEmpty()) {
            return TraceState.getDefault();
        }
        TraceStateBuilder traceStateBuilder = TraceState.builder();
        String[] listMembers = TRACESTATE_ENTRY_DELIMITER_SPLIT_PATTERN.split(traceStateHeader);
        for (int i = listMembers.length - 1; i >= 0; --i) {
            String listMember = listMembers[i];
            int index = listMember.indexOf(61);
            traceStateBuilder.put(listMember.substring(0, index), listMember.substring(index + 1));
        }
        return traceStateBuilder.build();
    }

    private static String bytesToHex(byte[] bytes) {
        char[] dest = new char[bytes.length * 2];
        AgentTestingExporterAccess.bytesToBase16(bytes, dest);
        return new String(dest);
    }

    private static void bytesToBase16(byte[] bytes, char[] dest) {
        for (int i = 0; i < bytes.length; ++i) {
            AgentTestingExporterAccess.byteToBase16(bytes[i], dest, i * 2);
        }
    }

    private static void byteToBase16(byte value, char[] dest, int destOffset) {
        int b = value & 0xFF;
        dest[destOffset] = ENCODING[b];
        dest[destOffset + 1] = ENCODING[b | 0x100];
    }

    private static char[] buildEncodingArray() {
        char[] encoding = new char[512];
        for (int i = 0; i < 256; ++i) {
            encoding[i] = ALPHABET.charAt(i >>> 4);
            encoding[i | 0x100] = ALPHABET.charAt(i & 0xF);
        }
        return encoding;
    }

    private static String emptyToNull(String string) {
        return string == null || string.isEmpty() ? null : string;
    }

    private AgentTestingExporterAccess() {
    }

    static {
        canUseValue = AgentTestingExporterAccess.classAvailable("io.opentelemetry.api.common.Value");
        hasExtendedLogRecordData = AgentTestingExporterAccess.classAvailable("io.opentelemetry.sdk.logs.data.internal.ExtendedLogRecordData");
        hasExtendedAttributes = AgentTestingExporterAccess.classAvailable("io.opentelemetry.api.incubator.common.ExtendedAttributes");
        try {
            Class<?> agentTestingExporterFactoryClass = AgentClassLoaderAccess.loadClass("io.opentelemetry.javaagent.testing.exporter.AgentTestingExporterFactory");
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            getSpanExportRequests = lookup.findStatic(agentTestingExporterFactoryClass, "getSpanExportRequests", MethodType.methodType(List.class));
            getMetricExportRequests = lookup.findStatic(agentTestingExporterFactoryClass, "getMetricExportRequests", MethodType.methodType(List.class));
            getLogExportRequests = lookup.findStatic(agentTestingExporterFactoryClass, "getLogExportRequests", MethodType.methodType(List.class));
            reset = lookup.findStatic(agentTestingExporterFactoryClass, "reset", MethodType.methodType(Void.TYPE));
            forceFlushCalled = lookup.findStatic(agentTestingExporterFactoryClass, "forceFlushCalled", MethodType.methodType(Boolean.TYPE));
        }
        catch (Exception e) {
            throw new AssertionError("Error accessing fields with reflection.", e);
        }
        ENCODING = AgentTestingExporterAccess.buildEncodingArray();
    }
}

