/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.testing.recording;

import com.github.tomakehurst.wiremock.common.FileSource;
import com.github.tomakehurst.wiremock.extension.Parameters;
import com.github.tomakehurst.wiremock.extension.ResponseTransformer;
import com.github.tomakehurst.wiremock.http.HttpHeader;
import com.github.tomakehurst.wiremock.http.HttpHeaders;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.Response;

public final class ResponseHeaderScrubber
extends ResponseTransformer {
    @Override
    public String getName() {
        return "scrub-response-header";
    }

    @Override
    public Response transform(Request request, Response response, FileSource fileSource, Parameters parameters) {
        HttpHeaders scrubbed = HttpHeaders.noHeaders();
        block8: for (HttpHeader header : response.getHeaders().all()) {
            switch (header.key()) {
                case "Set-Cookie": {
                    scrubbed = scrubbed.plus(HttpHeader.httpHeader("Set-Cookie", "test_set_cookie"));
                    continue block8;
                }
                case "openai-organization": {
                    scrubbed = scrubbed.plus(HttpHeader.httpHeader("openai-organization", "test_organization"));
                    continue block8;
                }
            }
            scrubbed = scrubbed.plus(header);
        }
        return Response.Builder.like(response).but().headers(scrubbed).build();
    }
}

