/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.testing.recording;

import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.common.SingleRootFileSource;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.junit5.WireMockExtension;
import com.github.tomakehurst.wiremock.junit5.WireMockRuntimeInfo;
import io.opentelemetry.instrumentation.testing.recording.PrettyPrintEqualToJsonStubMappingTransformer;
import io.opentelemetry.instrumentation.testing.recording.ResponseHeaderScrubber;
import io.opentelemetry.instrumentation.testing.recording.YamlFileMappingsSource;
import org.junit.jupiter.api.extension.AfterTestExecutionCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public final class RecordingExtension
extends WireMockExtension
implements AfterTestExecutionCallback {
    private static final boolean RECORD_WITH_REAL_API = System.getenv("RECORD_WITH_REAL_API") != null;
    private final String apiUrl;

    public RecordingExtension(String apiUrl) {
        super(WireMockExtension.newInstance().options(WireMockConfiguration.options().dynamicPort().extensions(ResponseHeaderScrubber.class, PrettyPrintEqualToJsonStubMappingTransformer.class).mappingSource(new YamlFileMappingsSource(new SingleRootFileSource("../testing/src/main/resources").child("mappings")))));
        this.apiUrl = apiUrl;
    }

    public boolean isRecording() {
        return RECORD_WITH_REAL_API;
    }

    @Override
    protected void onBeforeEach(WireMockRuntimeInfo wireMock) {
        if (RECORD_WITH_REAL_API) {
            this.stubFor(WireMock.proxyAllTo(this.apiUrl).atPriority(Integer.MAX_VALUE));
            this.startRecording(WireMock.recordSpec().forTarget(this.apiUrl).transformers("scrub-response-header", "pretty-print-equal-to-json").extractTextBodiesOver(Long.MAX_VALUE).extractBinaryBodiesOver(Long.MAX_VALUE));
        }
    }

    @Override
    protected void onAfterEach(WireMockRuntimeInfo wireMockRuntimeInfo) {
        if (RECORD_WITH_REAL_API) {
            this.stopRecording();
        }
    }

    public void afterTestExecution(ExtensionContext context) {
        YamlFileMappingsSource.setCurrentTest(context);
    }
}

