/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.testing.junit.http;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;

public final class HttpClientResult {
    private static final long timeout = 10000L;
    private final CountDownLatch valueReady = new CountDownLatch(1);
    private final Runnable callback;
    private int status;
    private Throwable throwable;

    public HttpClientResult(Runnable callback) {
        this.callback = callback;
    }

    public void complete(int status) {
        this.complete(() -> status, null);
    }

    public void complete(Throwable throwable) {
        this.complete(null, throwable);
    }

    public void complete(Supplier<Integer> status, Throwable throwable) {
        if (throwable != null) {
            this.throwable = throwable;
        } else {
            this.status = status.get();
        }
        this.callback.run();
        this.valueReady.countDown();
    }

    public int get() throws Throwable {
        if (!this.valueReady.await(10000L, TimeUnit.MILLISECONDS)) {
            throw new TimeoutException("Timed out waiting for response in 10000ms");
        }
        if (this.throwable != null) {
            throw this.throwable;
        }
        return this.status;
    }
}

