/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.testing.junit.db;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.instrumentation.api.internal.SemconvStability;
import io.opentelemetry.instrumentation.testing.junit.InstrumentationExtension;
import io.opentelemetry.sdk.testing.assertj.OpenTelemetryAssertions;
import io.opentelemetry.semconv.DbAttributes;
import java.util.Map;
import java.util.function.Consumer;

public class DbClientMetricsTestUtil {
    private DbClientMetricsTestUtil() {
    }

    public static void assertDurationMetric(InstrumentationExtension testing, String instrumentationName, AttributeKey<?> ... expectedKeys) {
        OpenTelemetryAssertions.assertThat((Object[])expectedKeys).extracting(AttributeKey::getKey).contains((Object[])new String[]{DbAttributes.DB_SYSTEM_NAME.getKey()});
        if (!SemconvStability.emitStableDatabaseSemconv()) {
            return;
        }
        testing.waitAndAssertMetrics(instrumentationName, metrics -> metrics.hasName("db.client.operation.duration").hasUnit("s").hasDescription("Duration of database client operations.").hasHistogramSatisfying(histogram -> histogram.hasPointsSatisfying(new Consumer[]{point -> point.hasAttributesSatisfying(attributes -> OpenTelemetryAssertions.assertThat((Map)attributes.asMap()).containsOnlyKeys((Object[])expectedKeys))})));
    }
}

