/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.testing.junit.code;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.instrumentation.api.internal.SemconvStability;
import io.opentelemetry.sdk.testing.assertj.AttributeAssertion;
import io.opentelemetry.sdk.testing.assertj.OpenTelemetryAssertions;
import io.opentelemetry.semconv.CodeAttributes;
import io.opentelemetry.semconv.incubating.CodeIncubatingAttributes;
import java.util.ArrayList;
import java.util.List;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.AbstractStringAssert;

public class SemconvCodeStabilityUtil {
    public static List<AttributeAssertion> codeFunctionAssertions(Class<?> type, String methodName) {
        return SemconvCodeStabilityUtil.codeFunctionAssertions(type.getName(), methodName);
    }

    public static List<AttributeAssertion> codeFunctionAssertions(String type, String methodName) {
        return SemconvCodeStabilityUtil.internalFunctionAssert(methodName, v -> v.isEqualTo(type + "." + methodName), v -> v.isEqualTo(type));
    }

    public static List<AttributeAssertion> codeFileAndLineAssertions(String filePath) {
        ArrayList<AttributeAssertion> assertions = new ArrayList<AttributeAssertion>();
        if (SemconvStability.isEmitStableCodeSemconv()) {
            assertions.add(OpenTelemetryAssertions.equalTo((AttributeKey)CodeAttributes.CODE_FILE_PATH, (Object)filePath));
            assertions.add(OpenTelemetryAssertions.satisfies((AttributeKey)CodeAttributes.CODE_LINE_NUMBER, AbstractLongAssert::isPositive));
        }
        if (SemconvStability.isEmitOldCodeSemconv()) {
            assertions.add(OpenTelemetryAssertions.equalTo((AttributeKey)CodeIncubatingAttributes.CODE_FILEPATH, (Object)filePath));
            assertions.add(OpenTelemetryAssertions.satisfies((AttributeKey)CodeIncubatingAttributes.CODE_LINENO, AbstractLongAssert::isPositive));
        }
        return assertions;
    }

    public static List<AttributeAssertion> codeFunctionSuffixAssertions(String methodName) {
        return SemconvCodeStabilityUtil.internalFunctionAssert(methodName, v -> v.endsWith((CharSequence)("." + methodName)), AbstractCharSequenceAssert::isNotEmpty);
    }

    public static List<AttributeAssertion> codeFunctionSuffixAssertions(String namespaceSuffix, String methodName) {
        return SemconvCodeStabilityUtil.internalFunctionAssert(methodName, v -> v.endsWith((CharSequence)(namespaceSuffix + "." + methodName)), v -> v.endsWith((CharSequence)namespaceSuffix));
    }

    public static List<AttributeAssertion> codeFunctionInfixAssertions(String namespaceInfix, String methodName) {
        return SemconvCodeStabilityUtil.internalFunctionAssert(methodName, v -> ((AbstractStringAssert)v.contains(new CharSequence[]{namespaceInfix})).endsWith((CharSequence)("." + methodName)), v -> v.contains(new CharSequence[]{namespaceInfix}));
    }

    public static List<AttributeAssertion> codeFunctionPrefixAssertions(String namespacePrefix, String methodName) {
        return SemconvCodeStabilityUtil.internalFunctionAssert(methodName, v -> ((AbstractStringAssert)v.startsWith((CharSequence)namespacePrefix)).endsWith((CharSequence)methodName), v -> v.startsWith((CharSequence)namespacePrefix));
    }

    private static List<AttributeAssertion> internalFunctionAssert(String methodName, OpenTelemetryAssertions.StringAssertConsumer functionNameAssert, OpenTelemetryAssertions.StringAssertConsumer namespaceAssert) {
        ArrayList<AttributeAssertion> assertions = new ArrayList<AttributeAssertion>();
        if (SemconvStability.isEmitStableCodeSemconv()) {
            assertions.add(OpenTelemetryAssertions.satisfies((AttributeKey)CodeAttributes.CODE_FUNCTION_NAME, (OpenTelemetryAssertions.StringAssertConsumer)functionNameAssert));
        }
        if (SemconvStability.isEmitOldCodeSemconv()) {
            assertions.add(OpenTelemetryAssertions.equalTo((AttributeKey)CodeIncubatingAttributes.CODE_FUNCTION, (Object)methodName));
            assertions.add(OpenTelemetryAssertions.satisfies((AttributeKey)CodeIncubatingAttributes.CODE_NAMESPACE, (OpenTelemetryAssertions.StringAssertConsumer)namespaceAssert));
        }
        return assertions;
    }

    public static int codeAttributesLogCount() {
        int count = 0;
        if (SemconvStability.isEmitOldCodeSemconv()) {
            count += 4;
        }
        if (SemconvStability.isEmitStableCodeSemconv()) {
            count += 3;
        }
        return count;
    }

    private SemconvCodeStabilityUtil() {
    }
}

