/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.testing;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.api.trace.TraceFlags;
import io.opentelemetry.api.trace.TraceState;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.SpanKindExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.SpanNameExtractor;
import io.opentelemetry.instrumentation.api.internal.SpanKey;
import io.opentelemetry.instrumentation.api.internal.SpanKeyProvider;
import io.opentelemetry.instrumentation.api.semconv.http.HttpServerAttributesExtractor;
import io.opentelemetry.instrumentation.api.semconv.http.HttpServerAttributesGetter;
import io.opentelemetry.instrumentation.api.semconv.http.HttpServerRoute;
import io.opentelemetry.instrumentation.api.semconv.http.HttpSpanNameExtractor;
import io.opentelemetry.instrumentation.testing.util.ThrowingSupplier;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;

final class TestInstrumenters {
    private final Instrumenter<String, Void> instrumenter;
    private final Instrumenter<String, Void> httpClientInstrumenter;
    private final Instrumenter<String, Void> httpServerInstrumenter;

    TestInstrumenters(OpenTelemetry openTelemetry) {
        this.instrumenter = Instrumenter.builder((OpenTelemetry)openTelemetry, (String)"test", name -> name).buildInstrumenter(SpanKindExtractor.alwaysInternal());
        this.httpClientInstrumenter = Instrumenter.builder((OpenTelemetry)openTelemetry, (String)"test", name -> name).addAttributesExtractor((AttributesExtractor)new SpanKeyAttributesExtractor(SpanKey.HTTP_CLIENT)).addAttributesExtractor((AttributesExtractor)new SpanKeyAttributesExtractor(SpanKey.KIND_CLIENT)).buildInstrumenter(SpanKindExtractor.alwaysClient());
        this.httpServerInstrumenter = Instrumenter.builder((OpenTelemetry)openTelemetry, (String)"test", (SpanNameExtractor)HttpSpanNameExtractor.create((HttpServerAttributesGetter)HttpServerGetter.INSTANCE)).addAttributesExtractor(HttpServerAttributesExtractor.create((HttpServerAttributesGetter)HttpServerGetter.INSTANCE)).addAttributesExtractor((AttributesExtractor)new SpanKeyAttributesExtractor(SpanKey.KIND_SERVER)).addContextCustomizer(HttpServerRoute.create((HttpServerAttributesGetter)HttpServerGetter.INSTANCE)).buildInstrumenter(SpanKindExtractor.alwaysServer());
    }

    <T, E extends Throwable> T runWithSpan(String spanName, ThrowingSupplier<T, E> callback) throws E {
        return TestInstrumenters.runWithInstrumenter(spanName, this.instrumenter, callback);
    }

    <T, E extends Throwable> T runWithHttpClientSpan(String spanName, ThrowingSupplier<T, E> callback) throws E {
        return TestInstrumenters.runWithInstrumenter(spanName, this.httpClientInstrumenter, callback);
    }

    <T, E extends Throwable> T runWithHttpServerSpan(ThrowingSupplier<T, E> callback) throws E {
        return TestInstrumenters.runWithInstrumenter("ignored", this.httpServerInstrumenter, callback);
    }

    <T, E extends Throwable> T runWithNonRecordingSpan(ThrowingSupplier<T, E> callback) throws E {
        SpanContext spanContext = SpanContext.create((String)"12345678123456781234567812345678", (String)"1234567812345678", (TraceFlags)TraceFlags.getDefault(), (TraceState)TraceState.getDefault());
        try (Scope ignored = Span.wrap((SpanContext)spanContext).makeCurrent();){
            T t = callback.get();
            return t;
        }
    }

    private static <T, E extends Throwable> T runWithInstrumenter(String spanName, Instrumenter<String, Void> instrumenter, ThrowingSupplier<T, E> callback) throws E {
        T result;
        Context context = instrumenter.start(Context.current(), (Object)spanName);
        try (Scope ignored = context.makeCurrent();){
            result = callback.get();
        }
        catch (Throwable t) {
            instrumenter.end(context, (Object)spanName, null, t);
            throw t;
        }
        instrumenter.end(context, (Object)spanName, null, null);
        return result;
    }

    private static final class SpanKeyAttributesExtractor
    implements AttributesExtractor<String, Void>,
    SpanKeyProvider {
        private final SpanKey spanKey;

        private SpanKeyAttributesExtractor(SpanKey spanKey) {
            this.spanKey = spanKey;
        }

        public void onStart(AttributesBuilder attributes, Context parentContext, String s) {
        }

        public void onEnd(AttributesBuilder attributes, Context context, String s, @Nullable Void unused, @Nullable Throwable error) {
        }

        public SpanKey internalGetSpanKey() {
            return this.spanKey;
        }
    }

    private static enum HttpServerGetter implements HttpServerAttributesGetter<String, Void>
    {
        INSTANCE;


        public String getHttpRequestMethod(String unused) {
            return "GET";
        }

        public List<String> getHttpRequestHeader(String unused, String name) {
            return Collections.emptyList();
        }

        @Nullable
        public Integer getHttpResponseStatusCode(String unused, Void unused2, @Nullable Throwable error) {
            return null;
        }

        public List<String> getHttpResponseHeader(String unused, Void unused2, String name) {
            return Collections.emptyList();
        }

        @Nullable
        public String getUrlScheme(String unused) {
            return null;
        }

        @Nullable
        public String getUrlPath(String s) {
            return null;
        }

        @Nullable
        public String getUrlQuery(String s) {
            return null;
        }
    }
}

