/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.stubbing;

import com.github.tomakehurst.wiremock.admin.NotFoundException;
import com.github.tomakehurst.wiremock.stubbing.Scenario;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import io.opentelemetry.testing.internal.guava.base.Function;
import io.opentelemetry.testing.internal.guava.base.MoreObjects;
import io.opentelemetry.testing.internal.guava.collect.ImmutableList;
import io.opentelemetry.testing.internal.guava.collect.Maps;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

public class Scenarios {
    private final ConcurrentHashMap<String, Scenario> scenarioMap = new ConcurrentHashMap();

    public Scenario getByName(String name) {
        return this.scenarioMap.get(name);
    }

    public List<Scenario> getAll() {
        return ImmutableList.copyOf(this.scenarioMap.values());
    }

    public void onStubMappingAdded(StubMapping mapping) {
        if (mapping.isInScenario()) {
            String scenarioName = mapping.getScenarioName();
            Scenario scenario = MoreObjects.firstNonNull(this.scenarioMap.get(scenarioName), Scenario.inStartedState(scenarioName)).withStubMapping(mapping);
            this.scenarioMap.put(scenarioName, scenario);
        }
    }

    public void onStubMappingUpdated(StubMapping oldMapping, StubMapping newMapping) {
        if (oldMapping.isInScenario() && !newMapping.getScenarioName().equals(oldMapping.getScenarioName())) {
            Scenario scenarioForOldMapping = this.scenarioMap.get(oldMapping.getScenarioName()).withoutStubMapping(oldMapping);
            if (scenarioForOldMapping.getMappings().isEmpty()) {
                this.scenarioMap.remove(scenarioForOldMapping.getId());
            } else {
                this.scenarioMap.put(oldMapping.getScenarioName(), scenarioForOldMapping);
            }
        }
        if (newMapping.isInScenario()) {
            String scenarioName = newMapping.getScenarioName();
            Scenario scenario = MoreObjects.firstNonNull(this.scenarioMap.get(scenarioName), Scenario.inStartedState(scenarioName)).withStubMapping(newMapping);
            this.scenarioMap.put(scenarioName, scenario);
        }
    }

    public void onStubMappingRemoved(StubMapping mapping) {
        if (mapping.isInScenario()) {
            String scenarioName = mapping.getScenarioName();
            Scenario scenario = this.scenarioMap.get(scenarioName).withoutStubMapping(mapping);
            if (scenario.getMappings().isEmpty()) {
                this.scenarioMap.remove(scenarioName);
            } else {
                this.scenarioMap.put(scenarioName, scenario);
            }
        }
    }

    public void onStubServed(StubMapping mapping) {
        if (mapping.isInScenario()) {
            String scenarioName = mapping.getScenarioName();
            Scenario scenario = this.scenarioMap.get(scenarioName);
            if (mapping.modifiesScenarioState() && (mapping.getRequiredScenarioState() == null || scenario.getState().equals(mapping.getRequiredScenarioState()))) {
                Scenario newScenario = scenario.setState(mapping.getNewScenarioState());
                this.scenarioMap.put(scenarioName, newScenario);
            }
        }
    }

    public void reset() {
        this.scenarioMap.putAll(Maps.transformValues(this.scenarioMap, new Function<Scenario, Scenario>(){

            @Override
            public Scenario apply(Scenario input) {
                return input.reset();
            }
        }));
    }

    public void resetSingle(String name) {
        this.setSingleScenarioState(name, Scenario::reset);
    }

    public void setSingle(String name, String state) {
        this.setSingleScenarioState(name, scenario -> scenario.setState(state));
    }

    private void setSingleScenarioState(String name, java.util.function.Function<Scenario, Scenario> fn) {
        Scenario scenario = this.scenarioMap.get(name);
        if (scenario == null) {
            throw new NotFoundException("Scenario " + name + " does not exist");
        }
        this.scenarioMap.replace(name, fn.apply(scenario));
    }

    public void clear() {
        this.scenarioMap.clear();
    }

    public boolean mappingMatchesScenarioState(StubMapping mapping) {
        String currentScenarioState = this.getByName(mapping.getScenarioName()).getState();
        return mapping.getRequiredScenarioState().equals(currentScenarioState);
    }
}

