/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.servlet;

import com.github.tomakehurst.wiremock.common.Encoding;
import com.github.tomakehurst.wiremock.common.Gzip;
import com.github.tomakehurst.wiremock.common.Strings;
import com.github.tomakehurst.wiremock.common.Urls;
import com.github.tomakehurst.wiremock.http.ContentTypeHeader;
import com.github.tomakehurst.wiremock.http.HttpHeader;
import com.github.tomakehurst.wiremock.http.HttpHeaders;
import com.github.tomakehurst.wiremock.http.QueryParameter;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.RequestMethod;
import com.github.tomakehurst.wiremock.http.multipart.PartParser;
import com.github.tomakehurst.wiremock.jetty9.JettyUtils;
import com.github.tomakehurst.wiremock.servlet.MultipartRequestConfigurer;
import io.opentelemetry.testing.internal.guava.base.Charsets;
import io.opentelemetry.testing.internal.guava.base.MoreObjects;
import io.opentelemetry.testing.internal.guava.base.Optional;
import io.opentelemetry.testing.internal.guava.base.Predicate;
import io.opentelemetry.testing.internal.guava.base.Supplier;
import io.opentelemetry.testing.internal.guava.base.Suppliers;
import io.opentelemetry.testing.internal.guava.collect.FluentIterable;
import io.opentelemetry.testing.internal.guava.collect.ImmutableList;
import io.opentelemetry.testing.internal.guava.collect.ImmutableMultimap;
import io.opentelemetry.testing.internal.guava.collect.Lists;
import io.opentelemetry.testing.internal.guava.collect.Maps;
import io.opentelemetry.testing.internal.guava.io.ByteStreams;
import io.opentelemetry.testing.internal.jetty.server.Request;
import io.opentelemetry.testing.internal.servlet.http.Cookie;
import io.opentelemetry.testing.internal.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class WireMockHttpServletRequestAdapter
implements com.github.tomakehurst.wiremock.http.Request {
    public static final String ORIGINAL_REQUEST_KEY = "wiremock.ORIGINAL_REQUEST";
    private final HttpServletRequest request;
    private final MultipartRequestConfigurer multipartRequestConfigurer;
    private byte[] cachedBody;
    private final Supplier<Map<String, QueryParameter>> cachedQueryParams;
    private final boolean browserProxyingEnabled;
    private final String urlPrefixToRemove;
    private Collection<Request.Part> cachedMultiparts;

    public WireMockHttpServletRequestAdapter(final HttpServletRequest request, MultipartRequestConfigurer multipartRequestConfigurer, String urlPrefixToRemove, boolean browserProxyingEnabled) {
        this.request = request;
        this.multipartRequestConfigurer = multipartRequestConfigurer;
        this.urlPrefixToRemove = urlPrefixToRemove;
        this.browserProxyingEnabled = browserProxyingEnabled;
        this.cachedQueryParams = Suppliers.memoize(new Supplier<Map<String, QueryParameter>>(){

            @Override
            public Map<String, QueryParameter> get() {
                return Urls.splitQuery(request.getQueryString());
            }
        });
    }

    @Override
    public String getUrl() {
        String url = this.request.getRequestURI();
        String contextPath = this.request.getContextPath();
        if (!io.opentelemetry.testing.internal.guava.base.Strings.isNullOrEmpty(contextPath) && url.startsWith(contextPath)) {
            url = url.substring(contextPath.length());
        }
        if (!io.opentelemetry.testing.internal.guava.base.Strings.isNullOrEmpty(this.urlPrefixToRemove) && url.startsWith(this.urlPrefixToRemove)) {
            url = url.substring(this.urlPrefixToRemove.length());
        }
        return this.withQueryStringIfPresent(url);
    }

    @Override
    public String getAbsoluteUrl() {
        return this.withQueryStringIfPresent(this.request.getRequestURL().toString());
    }

    private String withQueryStringIfPresent(String url) {
        return url + (io.opentelemetry.testing.internal.guava.base.Strings.isNullOrEmpty(this.request.getQueryString()) ? "" : "?" + this.request.getQueryString());
    }

    @Override
    public RequestMethod getMethod() {
        return RequestMethod.fromString(this.request.getMethod().toUpperCase());
    }

    @Override
    public String getScheme() {
        return this.request.getScheme();
    }

    @Override
    public String getHost() {
        return this.request.getServerName();
    }

    @Override
    public int getPort() {
        return this.request.getServerPort();
    }

    @Override
    public String getClientIp() {
        String forwardedForHeader = this.getHeader("X-Forwarded-For");
        if (forwardedForHeader != null && forwardedForHeader.length() > 0) {
            return forwardedForHeader;
        }
        return this.request.getRemoteAddr();
    }

    @Override
    public byte[] getBody() {
        if (this.cachedBody == null) {
            try {
                byte[] body = ByteStreams.toByteArray(this.request.getInputStream());
                boolean isGzipped = this.hasGzipEncoding() || Gzip.isGzipped(body);
                this.cachedBody = isGzipped ? Gzip.unGzip(body) : body;
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }
        return this.cachedBody;
    }

    private Charset encodingFromContentTypeHeaderOrUtf8() {
        ContentTypeHeader contentTypeHeader = this.contentTypeHeader();
        if (contentTypeHeader != null) {
            return contentTypeHeader.charset();
        }
        return Charsets.UTF_8;
    }

    private boolean hasGzipEncoding() {
        String encodingHeader = this.request.getHeader("Content-Encoding");
        return encodingHeader != null && encodingHeader.contains("gzip");
    }

    @Override
    public String getBodyAsString() {
        return Strings.stringFromBytes(this.getBody(), this.encodingFromContentTypeHeaderOrUtf8());
    }

    @Override
    public String getBodyAsBase64() {
        return Encoding.encodeBase64(this.getBody());
    }

    @Override
    public String getHeader(String key) {
        return this.request.getHeader(key);
    }

    @Override
    public HttpHeader header(String key) {
        if (this.request.getHeader(key) == null) {
            return HttpHeader.absent(key);
        }
        ArrayList<String> valueList = Collections.list(this.request.getHeaders(key));
        if (valueList.isEmpty()) {
            return HttpHeader.empty(key);
        }
        return new HttpHeader(key, (Collection<String>)valueList);
    }

    @Override
    public ContentTypeHeader contentTypeHeader() {
        String firstValue = this.getHeader("Content-Type");
        return firstValue == null ? ContentTypeHeader.absent() : new ContentTypeHeader(firstValue);
    }

    @Override
    public boolean containsHeader(String key) {
        return this.header(key).isPresent();
    }

    @Override
    public HttpHeaders getHeaders() {
        if (this.request instanceof Request) {
            return WireMockHttpServletRequestAdapter.getHeadersLinear((Request)this.request);
        }
        return this.getHeadersQuadratic();
    }

    private static HttpHeaders getHeadersLinear(Request request) {
        Request jettyRequest = request;
        List<HttpHeader> headers = jettyRequest.getHttpFields().stream().map(field -> HttpHeader.httpHeader(field.getName(), field.getValue())).collect(Collectors.toList());
        return new HttpHeaders(headers);
    }

    private HttpHeaders getHeadersQuadratic() {
        ArrayList<HttpHeader> headerList = Lists.newArrayList();
        for (String key : this.getAllHeaderKeys()) {
            headerList.add(this.header(key));
        }
        return new HttpHeaders(headerList);
    }

    @Override
    public Set<String> getAllHeaderKeys() {
        LinkedHashSet<String> headerKeys = new LinkedHashSet<String>();
        Enumeration<String> headerNames = this.request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            headerKeys.add(headerNames.nextElement());
        }
        return headerKeys;
    }

    @Override
    public Map<String, com.github.tomakehurst.wiremock.http.Cookie> getCookies() {
        Cookie[] cookies;
        ImmutableMultimap.Builder<String, String> builder = ImmutableMultimap.builder();
        for (Cookie cookie : cookies = MoreObjects.firstNonNull(this.request.getCookies(), new Cookie[0])) {
            builder.put(cookie.getName(), cookie.getValue());
        }
        return Maps.transformValues(builder.build().asMap(), input -> new com.github.tomakehurst.wiremock.http.Cookie(null, ImmutableList.copyOf(input)));
    }

    @Override
    public QueryParameter queryParameter(String key) {
        Map<String, QueryParameter> queryParams = this.cachedQueryParams.get();
        return MoreObjects.firstNonNull(queryParams.get(key), QueryParameter.absent(key));
    }

    @Override
    public boolean isBrowserProxyRequest() {
        if (!this.browserProxyingEnabled || !JettyUtils.isJetty()) {
            return false;
        }
        if (this.request instanceof Request) {
            Request jettyRequest = (Request)this.request;
            return JettyUtils.uriIsAbsolute(jettyRequest);
        }
        return false;
    }

    @Override
    public Collection<Request.Part> getParts() {
        if (!this.isMultipart()) {
            return null;
        }
        if (this.cachedMultiparts == null) {
            this.cachedMultiparts = PartParser.parseFrom(this);
        }
        return this.cachedMultiparts.size() > 0 ? this.cachedMultiparts : null;
    }

    @Override
    public boolean isMultipart() {
        String header = this.getHeader("Content-Type");
        return header != null && header.contains("multipart/");
    }

    @Override
    public Request.Part getPart(final String name) {
        if (name == null || name.length() == 0) {
            return null;
        }
        if (this.cachedMultiparts == null && this.getParts() == null) {
            return null;
        }
        return FluentIterable.from(this.cachedMultiparts).firstMatch(new Predicate<Request.Part>(){

            @Override
            public boolean apply(Request.Part input) {
                return name.equals(input.getName());
            }
        }).get();
    }

    @Override
    public Optional<com.github.tomakehurst.wiremock.http.Request> getOriginalRequest() {
        com.github.tomakehurst.wiremock.http.Request originalRequest = (com.github.tomakehurst.wiremock.http.Request)this.request.getAttribute(ORIGINAL_REQUEST_KEY);
        return Optional.fromNullable(originalRequest);
    }

    public String toString() {
        return this.request.toString() + this.getBodyAsString();
    }

    @Override
    public String getProtocol() {
        return this.request.getProtocol();
    }
}

