/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.servlet;

import io.opentelemetry.testing.internal.servlet.Filter;
import io.opentelemetry.testing.internal.servlet.FilterChain;
import io.opentelemetry.testing.internal.servlet.FilterConfig;
import io.opentelemetry.testing.internal.servlet.RequestDispatcher;
import io.opentelemetry.testing.internal.servlet.ServletException;
import io.opentelemetry.testing.internal.servlet.ServletRequest;
import io.opentelemetry.testing.internal.servlet.ServletResponse;
import io.opentelemetry.testing.internal.servlet.http.HttpServletRequest;
import io.opentelemetry.testing.internal.servlet.http.HttpServletResponse;
import io.opentelemetry.testing.internal.servlet.http.HttpServletResponseWrapper;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;

public class TrailingSlashFilter
implements Filter {
    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        String path = this.getRequestPathFrom(httpServletRequest);
        StatusAndRedirectExposingHttpServletResponse wrappedResponse = new StatusAndRedirectExposingHttpServletResponse((HttpServletResponse)response, path, httpServletRequest);
        chain.doFilter(request, wrappedResponse);
    }

    private static boolean isRelativePath(String location) {
        return location.matches("^/[^/]{1}.*");
    }

    private String getRequestPathFrom(HttpServletRequest httpServletRequest) throws ServletException {
        try {
            String fullPath = new URI(URLEncoder.encode(httpServletRequest.getRequestURI(), "utf-8")).getPath();
            String pathWithoutContext = fullPath.substring(httpServletRequest.getContextPath().length());
            return URLDecoder.decode(pathWithoutContext, "utf-8");
        }
        catch (URISyntaxException e) {
            throw new ServletException(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new ServletException(e);
        }
    }

    @Override
    public void destroy() {
    }

    private static class StatusAndRedirectExposingHttpServletResponse
    extends HttpServletResponseWrapper {
        private String path;
        private HttpServletRequest request;

        public StatusAndRedirectExposingHttpServletResponse(HttpServletResponse response, String path, HttpServletRequest request) {
            super(response);
            this.path = path;
            this.request = request;
        }

        @Override
        public void sendRedirect(String location) throws IOException {
            if (location.contains(this.path)) {
                RequestDispatcher dispatcher = this.request.getRequestDispatcher(this.getPathPartFromLocation(location));
                try {
                    dispatcher.forward(this.request, this);
                }
                catch (ServletException se) {
                    throw new IOException(se);
                }
            }
        }

        private String getPathPartFromLocation(String location) throws IOException {
            if (TrailingSlashFilter.isRelativePath(location)) {
                return location;
            }
            URL url = new URL(location);
            return url.getPath();
        }
    }
}

