/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.recording;

import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.matching.EqualToJsonPattern;
import com.github.tomakehurst.wiremock.recording.RequestBodyPatternFactory;
import io.opentelemetry.testing.internal.jackson.annotation.JsonCreator;
import io.opentelemetry.testing.internal.jackson.annotation.JsonProperty;

public class RequestBodyEqualToJsonPatternFactory
implements RequestBodyPatternFactory {
    private final Boolean ignoreArrayOrder;
    private final Boolean ignoreExtraElements;

    @JsonCreator
    public RequestBodyEqualToJsonPatternFactory(@JsonProperty(value="ignoreArrayOrder") Boolean ignoreArrayOrder, @JsonProperty(value="ignoreExtraElements") Boolean ignoreExtraElements) {
        this.ignoreArrayOrder = ignoreArrayOrder;
        this.ignoreExtraElements = ignoreExtraElements;
    }

    public Boolean isIgnoreArrayOrder() {
        return this.ignoreArrayOrder;
    }

    public Boolean isIgnoreExtraElements() {
        return this.ignoreExtraElements;
    }

    public EqualToJsonPattern forRequest(Request request) {
        return new EqualToJsonPattern(request.getBodyAsString(), this.ignoreArrayOrder, this.ignoreExtraElements);
    }
}

