/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.matching;

import com.github.tomakehurst.wiremock.matching.AdvancedPathPattern;
import com.github.tomakehurst.wiremock.matching.PathPattern;
import com.github.tomakehurst.wiremock.matching.StringValuePattern;
import io.opentelemetry.testing.internal.jackson.core.JsonGenerator;
import io.opentelemetry.testing.internal.jackson.databind.JavaType;
import io.opentelemetry.testing.internal.jackson.databind.JsonSerializer;
import io.opentelemetry.testing.internal.jackson.databind.SerializerProvider;
import io.opentelemetry.testing.internal.jackson.databind.ser.BeanSerializerFactory;
import java.io.IOException;

public abstract class PathPatternJsonSerializer<T extends PathPattern>
extends JsonSerializer<T> {
    @Override
    public void serialize(T value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        gen.writeStartObject();
        if (((PathPattern)value).isSimple()) {
            gen.writeStringField(((StringValuePattern)value).getName(), ((StringValuePattern)value).getExpected());
        } else {
            AdvancedPathPattern advancedPathPattern = new AdvancedPathPattern(((StringValuePattern)value).getExpected(), ((PathPattern)value).getValuePattern());
            gen.writeFieldName(((StringValuePattern)value).getName());
            JavaType javaType = serializers.getConfig().constructType(advancedPathPattern.getClass());
            JsonSerializer<Object> serializer = BeanSerializerFactory.instance.createSerializer(serializers, javaType);
            serializer.serialize(advancedPathPattern, gen, serializers);
        }
        this.serializeAdditionalFields(value, gen, serializers);
        gen.writeEndObject();
    }

    protected abstract void serializeAdditionalFields(T var1, JsonGenerator var2, SerializerProvider var3) throws IOException;
}

