/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.matching;

import com.github.tomakehurst.wiremock.matching.MatchResult;
import com.github.tomakehurst.wiremock.matching.StringValuePattern;
import io.opentelemetry.testing.internal.apachecommons.lang3.StringUtils;
import io.opentelemetry.testing.internal.jackson.annotation.JsonProperty;
import java.util.Objects;

public class EqualToPattern
extends StringValuePattern {
    private final Boolean caseInsensitive;

    public EqualToPattern(@JsonProperty(value="equalTo") String testValue, @JsonProperty(value="caseInsensitive") Boolean caseInsensitive) {
        super(testValue);
        this.caseInsensitive = caseInsensitive;
    }

    public EqualToPattern(String expectedValue) {
        this(expectedValue, null);
    }

    public String getEqualTo() {
        return (String)this.expectedValue;
    }

    public Boolean getCaseInsensitive() {
        return this.caseInsensitive;
    }

    @Override
    public MatchResult match(final String value) {
        return new MatchResult(){

            @Override
            public boolean isExactMatch() {
                return EqualToPattern.this.shouldMatchCaseInsensitive() ? value != null && value.equalsIgnoreCase((String)EqualToPattern.this.expectedValue) : Objects.equals(EqualToPattern.this.expectedValue, value);
            }

            @Override
            public double getDistance() {
                return EqualToPattern.this.normalisedLevenshteinDistance((String)EqualToPattern.this.expectedValue, value);
            }
        };
    }

    private boolean shouldMatchCaseInsensitive() {
        return this.caseInsensitive != null && this.caseInsensitive != false;
    }

    private double normalisedLevenshteinDistance(String one, String two) {
        if (one == null || two == null) {
            return 1.0;
        }
        double maxDistance = Math.max(one.length(), two.length());
        double actualDistance = StringUtils.getLevenshteinDistance(one, two);
        return actualDistance / maxDistance;
    }
}

