/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.extension.responsetemplating.helpers;

import com.github.jknack.handlebars.Options;
import com.github.tomakehurst.wiremock.extension.responsetemplating.helpers.HandlebarsHelper;
import io.opentelemetry.testing.internal.apachecommons.lang3.RandomStringUtils;
import java.io.IOException;
import java.util.UUID;

public class HandlebarsRandomValuesHelper
extends HandlebarsHelper<Void> {
    @Override
    public Object apply(Void context, Options options) throws IOException {
        String rawValue;
        String type;
        int length = (Integer)options.hash("length", 36);
        boolean uppercase = (Boolean)options.hash("uppercase", false);
        switch (type = (String)options.hash("type", "ALPHANUMERIC")) {
            case "ALPHANUMERIC": {
                rawValue = RandomStringUtils.randomAlphanumeric(length);
                break;
            }
            case "ALPHABETIC": {
                rawValue = RandomStringUtils.randomAlphabetic(length);
                break;
            }
            case "NUMERIC": {
                rawValue = RandomStringUtils.randomNumeric(length);
                break;
            }
            case "ALPHANUMERIC_AND_SYMBOLS": {
                rawValue = RandomStringUtils.random(length, 33, 126, false, false);
                break;
            }
            case "UUID": {
                rawValue = UUID.randomUUID().toString();
                break;
            }
            case "HEXADECIMAL": {
                rawValue = RandomStringUtils.random(length, "ABCDEF0123456789");
                break;
            }
            default: {
                rawValue = RandomStringUtils.randomAscii(length);
            }
        }
        return uppercase ? rawValue.toUpperCase() : rawValue.toLowerCase();
    }
}

