/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.extension.responsetemplating;

import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.Helper;
import com.github.jknack.handlebars.helper.AssignHelper;
import com.github.jknack.handlebars.helper.ConditionalHelpers;
import com.github.jknack.handlebars.helper.NumberHelper;
import com.github.jknack.handlebars.helper.StringHelpers;
import com.github.tomakehurst.wiremock.common.Exceptions;
import com.github.tomakehurst.wiremock.extension.responsetemplating.HandlebarsOptimizedTemplate;
import com.github.tomakehurst.wiremock.extension.responsetemplating.SystemKeyAuthoriser;
import com.github.tomakehurst.wiremock.extension.responsetemplating.helpers.SystemValueHelper;
import com.github.tomakehurst.wiremock.extension.responsetemplating.helpers.WireMockHelpers;
import io.opentelemetry.testing.internal.guava.cache.Cache;
import io.opentelemetry.testing.internal.guava.cache.CacheBuilder;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;

public class TemplateEngine {
    private final Handlebars handlebars;
    private final Cache<Object, HandlebarsOptimizedTemplate> cache;
    private final Long maxCacheEntries;

    public TemplateEngine(Map<String, Helper<?>> helpers, Long maxCacheEntries, Set<String> permittedSystemKeys) {
        this(new Handlebars(), helpers, maxCacheEntries, permittedSystemKeys);
    }

    public TemplateEngine(Handlebars handlebars, Map<String, Helper<?>> helpers, Long maxCacheEntries, Set<String> permittedSystemKeys) {
        this.handlebars = handlebars;
        this.maxCacheEntries = maxCacheEntries;
        CacheBuilder<Object, Object> cacheBuilder = CacheBuilder.newBuilder();
        if (maxCacheEntries != null) {
            cacheBuilder.maximumSize(maxCacheEntries);
        }
        this.cache = cacheBuilder.build();
        this.addHelpers(helpers, permittedSystemKeys);
    }

    private void addHelpers(Map<String, Helper<?>> helpers, Set<String> permittedSystemKeys) {
        for (StringHelpers stringHelpers : StringHelpers.values()) {
            if (stringHelpers.name().equals("now")) continue;
            this.handlebars.registerHelper(stringHelpers.name(), (Helper)stringHelpers);
        }
        for (Enum enum_ : NumberHelper.values()) {
            this.handlebars.registerHelper(enum_.name(), (Helper)((Object)enum_));
        }
        for (Enum enum_ : ConditionalHelpers.values()) {
            this.handlebars.registerHelper(enum_.name(), (Helper)((Object)enum_));
        }
        this.handlebars.registerHelper("assign", (Helper)new AssignHelper());
        for (Enum enum_ : WireMockHelpers.values()) {
            this.handlebars.registerHelper(enum_.name(), (Helper)((Object)enum_));
        }
        this.handlebars.registerHelper("systemValue", (Helper)new SystemValueHelper(new SystemKeyAuthoriser(permittedSystemKeys)));
        for (Map.Entry entry : helpers.entrySet()) {
            this.handlebars.registerHelper((String)entry.getKey(), (Helper)entry.getValue());
        }
    }

    public HandlebarsOptimizedTemplate getTemplate(Object key, String content) {
        if (this.maxCacheEntries != null && this.maxCacheEntries < 1L) {
            return this.getUncachedTemplate(content);
        }
        try {
            return this.cache.get(key, () -> new HandlebarsOptimizedTemplate(this.handlebars, content));
        }
        catch (ExecutionException e) {
            return Exceptions.throwUnchecked(e, HandlebarsOptimizedTemplate.class);
        }
    }

    public HandlebarsOptimizedTemplate getUncachedTemplate(String content) {
        return new HandlebarsOptimizedTemplate(this.handlebars, content);
    }

    public long getCacheSize() {
        return this.cache.size();
    }

    public void invalidateCache() {
        this.cache.invalidateAll();
    }

    public Long getMaxCacheEntries() {
        return this.maxCacheEntries;
    }
}

