/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.extension;

import com.github.tomakehurst.wiremock.common.Exceptions;
import com.github.tomakehurst.wiremock.extension.Extension;
import io.opentelemetry.testing.internal.guava.base.Function;
import io.opentelemetry.testing.internal.guava.base.Predicate;
import io.opentelemetry.testing.internal.guava.collect.FluentIterable;
import io.opentelemetry.testing.internal.guava.collect.Maps;
import java.util.Arrays;
import java.util.Map;

public class ExtensionLoader {
    public static <T> Map<String, T> loadExtension(String ... classNames) {
        return ExtensionLoader.asMap(FluentIterable.from(Arrays.asList(classNames)).transform(ExtensionLoader.toClasses()).transform(ExtensionLoader.toExtensions()));
    }

    public static Map<String, Extension> load(String ... classNames) {
        return ExtensionLoader.loadExtension(classNames);
    }

    public static Map<String, Extension> asMap(Iterable<Extension> extensions) {
        return Maps.uniqueIndex(extensions, new Function<Extension, String>(){

            @Override
            public String apply(Extension extension) {
                return extension.getName();
            }
        });
    }

    public static Map<String, Extension> load(Class<? extends Extension> ... classes) {
        return ExtensionLoader.asMap(FluentIterable.from(Arrays.asList(classes)).transform(ExtensionLoader.toExtensions()));
    }

    private static Function<Class<? extends Extension>, Extension> toExtensions() {
        return new Function<Class<? extends Extension>, Extension>(){

            @Override
            public Extension apply(Class<? extends Extension> extensionClass) {
                try {
                    return extensionClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception e) {
                    return Exceptions.throwUnchecked(e, Extension.class);
                }
            }
        };
    }

    private static Function<String, Class<? extends Extension>> toClasses() {
        return new Function<String, Class<? extends Extension>>(){

            @Override
            public Class<? extends Extension> apply(String className) {
                try {
                    return Class.forName(className);
                }
                catch (ClassNotFoundException e) {
                    return Exceptions.throwUnchecked(e, Class.class);
                }
            }
        };
    }

    public static <T extends Extension> Predicate<Map.Entry<String, Extension>> valueAssignableFrom(final Class<T> extensionType) {
        return new Predicate<Map.Entry<String, Extension>>(){

            @Override
            public boolean apply(Map.Entry<String, Extension> input) {
                return extensionType.isAssignableFrom(input.getValue().getClass());
            }
        };
    }
}

