/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.common;

import com.github.tomakehurst.wiremock.common.ListOrSingle;
import io.opentelemetry.testing.internal.guava.collect.Lists;
import io.opentelemetry.testing.internal.jackson.core.JsonParser;
import io.opentelemetry.testing.internal.jackson.core.JsonProcessingException;
import io.opentelemetry.testing.internal.jackson.databind.DeserializationContext;
import io.opentelemetry.testing.internal.jackson.databind.JsonDeserializer;
import io.opentelemetry.testing.internal.jackson.databind.JsonNode;
import io.opentelemetry.testing.internal.jackson.databind.node.ArrayNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;

public class ListOrStringDeserialiser<T>
extends JsonDeserializer<ListOrSingle<T>> {
    @Override
    public ListOrSingle<T> deserialize(JsonParser parser, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonNode rootNode = (JsonNode)parser.readValueAsTree();
        if (rootNode.isArray()) {
            ArrayNode arrayNode = (ArrayNode)rootNode;
            ArrayList<Object> items = Lists.newArrayList();
            Iterator<JsonNode> i = arrayNode.elements();
            while (i.hasNext()) {
                JsonNode node = i.next();
                Object value = ListOrStringDeserialiser.getValue(node);
                items.add(value);
            }
            return new ListOrSingle(items);
        }
        return new ListOrSingle<Object>(ListOrStringDeserialiser.getValue(rootNode));
    }

    private static Object getValue(JsonNode node) {
        return node.isTextual() ? node.textValue() : (node.isNumber() ? node.numberValue() : (node.isBoolean() ? Boolean.valueOf(node.booleanValue()) : node.textValue()));
    }
}

