/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.common;

import com.github.tomakehurst.wiremock.common.BinaryFile;
import com.github.tomakehurst.wiremock.common.Exceptions;
import com.github.tomakehurst.wiremock.common.FileSource;
import com.github.tomakehurst.wiremock.common.TextFile;
import io.opentelemetry.testing.internal.guava.base.Function;
import io.opentelemetry.testing.internal.guava.base.MoreObjects;
import io.opentelemetry.testing.internal.guava.base.Predicate;
import io.opentelemetry.testing.internal.guava.collect.FluentIterable;
import io.opentelemetry.testing.internal.guava.collect.Iterables;
import io.opentelemetry.testing.internal.guava.collect.Iterators;
import io.opentelemetry.testing.internal.guava.collect.Lists;
import io.opentelemetry.testing.internal.guava.io.Resources;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ClasspathFileSource
implements FileSource {
    private final String path;
    private URI pathUri;
    private ZipFile zipFile;
    private File rootDirectory;

    public ClasspathFileSource(String path) {
        block5: {
            this.path = path;
            try {
                URL resource = MoreObjects.firstNonNull(Thread.currentThread().getContextClassLoader(), Resources.class.getClassLoader()).getResource(path);
                if (resource == null) {
                    this.rootDirectory = new File(path);
                    this.pathUri = this.rootDirectory.toURI();
                    return;
                }
                this.pathUri = resource.toURI();
                if (Arrays.asList("jar", "war", "ear", "zip").contains(this.pathUri.getScheme())) {
                    String jarFileUri = this.pathUri.getSchemeSpecificPart().split("!")[0];
                    String jarFilePath = jarFileUri.replace("file:", "");
                    File file = new File(jarFilePath);
                    this.zipFile = new ZipFile(file);
                    break block5;
                }
                if (this.pathUri.getScheme().equals("file")) {
                    this.rootDirectory = new File(this.pathUri);
                    break block5;
                }
                throw new RuntimeException("ClasspathFileSource can't handle paths of type " + this.pathUri.getScheme());
            }
            catch (Exception e) {
                Exceptions.throwUnchecked(e);
            }
        }
    }

    private boolean isFileSystem() {
        return this.rootDirectory != null;
    }

    @Override
    public BinaryFile getBinaryFileNamed(String name) {
        if (this.isFileSystem()) {
            return new BinaryFile(new File(this.rootDirectory, name).toURI());
        }
        return new BinaryFile(this.getZipEntryUri(name));
    }

    @Override
    public TextFile getTextFileNamed(String name) {
        if (this.isFileSystem()) {
            return new TextFile(new File(this.rootDirectory, name).toURI());
        }
        return new TextFile(this.getZipEntryUri(name));
    }

    private URI getZipEntryUri(String name) {
        String lookFor = this.path + "/" + name;
        Enumeration<? extends ZipEntry> enumeration = this.zipFile.entries();
        StringBuilder candidates = new StringBuilder();
        while (enumeration.hasMoreElements()) {
            ZipEntry candidate = enumeration.nextElement();
            if (candidate.getName().equals(lookFor)) {
                return this.getUriFor(candidate);
            }
            candidates.append(candidate.getName() + "\n");
        }
        throw new RuntimeException("Was unable to find entry: \"" + lookFor + "\", found:\n" + candidates.toString());
    }

    @Override
    public void createIfNecessary() {
    }

    @Override
    public FileSource child(String subDirectoryName) {
        return new ClasspathFileSource(this.path + "/" + subDirectoryName);
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public URI getUri() {
        return this.pathUri;
    }

    @Override
    public List<TextFile> listFilesRecursively() {
        if (this.isFileSystem()) {
            this.assertExistsAndIsDirectory();
            ArrayList<File> fileList = Lists.newArrayList();
            this.recursivelyAddFilesToList(this.rootDirectory, fileList);
            return this.toTextFileList(fileList);
        }
        return FluentIterable.from(ClasspathFileSource.toIterable(this.zipFile.entries())).filter((Predicate<? extends ZipEntry>)new Predicate<ZipEntry>(){

            @Override
            public boolean apply(ZipEntry jarEntry) {
                return !jarEntry.isDirectory() && jarEntry.getName().startsWith(ClasspathFileSource.this.path);
            }
        }).transform(new Function<ZipEntry, TextFile>(){

            @Override
            public TextFile apply(ZipEntry jarEntry) {
                return new TextFile(ClasspathFileSource.this.getUriFor(jarEntry));
            }
        }).toList();
    }

    private URI getUriFor(ZipEntry jarEntry) {
        try {
            return Resources.getResource(jarEntry.getName()).toURI();
        }
        catch (URISyntaxException e) {
            return Exceptions.throwUnchecked(e, URI.class);
        }
    }

    private void recursivelyAddFilesToList(File root, List<File> fileList) {
        File[] files;
        for (File file : files = root.listFiles()) {
            if (file.isDirectory()) {
                this.recursivelyAddFilesToList(file, fileList);
                continue;
            }
            fileList.add(file);
        }
    }

    private List<TextFile> toTextFileList(List<File> fileList) {
        return Lists.newArrayList(Iterables.transform(fileList, new Function<File, TextFile>(){

            @Override
            public TextFile apply(File input) {
                return new TextFile(input.toURI());
            }
        }));
    }

    @Override
    public void writeTextFile(String name, String contents) {
    }

    @Override
    public void writeBinaryFile(String name, byte[] contents) {
    }

    @Override
    public boolean exists() {
        return this.isFileSystem() && this.rootDirectory.exists() || !this.isFileSystem();
    }

    @Override
    public void deleteFile(String name) {
    }

    private static <T> Iterable<T> toIterable(final Enumeration<T> e) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return Iterators.forEnumeration(e);
            }
        };
    }

    private void assertExistsAndIsDirectory() {
        if (this.rootDirectory.exists() && !this.rootDirectory.isDirectory()) {
            throw new RuntimeException(this.rootDirectory + " is not a directory");
        }
        if (!this.rootDirectory.exists()) {
            throw new RuntimeException(this.rootDirectory + " does not exist");
        }
    }
}

