/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.client;

import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.common.Encoding;
import com.github.tomakehurst.wiremock.matching.MultiValuePattern;
import io.opentelemetry.testing.internal.jackson.annotation.JsonCreator;
import io.opentelemetry.testing.internal.jackson.annotation.JsonProperty;

public class BasicCredentials {
    public final String username;
    public final String password;

    @JsonCreator
    public BasicCredentials(@JsonProperty(value="username") String username, @JsonProperty(value="password") String password) {
        this.username = username;
        this.password = password;
    }

    public boolean present() {
        return this.username != null && this.password != null;
    }

    public MultiValuePattern asAuthorizationMultiValuePattern() {
        return MultiValuePattern.of(WireMock.equalToIgnoreCase(this.asAuthorizationHeaderValue()));
    }

    public String asAuthorizationHeaderValue() {
        byte[] usernameAndPassword = (this.username + ":" + this.password).getBytes();
        return "Basic " + Encoding.encodeBase64(usernameAndPassword);
    }
}

