/*
 * Decompiled with CFR 0.152.
 */
package com.github.jknack.handlebars.helper;

import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.Helper;
import com.github.jknack.handlebars.Options;
import io.opentelemetry.testing.internal.apachecommons.lang3.Validate;
import java.io.IOException;

public enum NumberHelper implements Helper<Object>
{
    isEven{

        @Override
        public CharSequence safeApply(Number value, Options options) {
            return this.isEven(value) ? (CharSequence)options.param(0, "even") : null;
        }
    }
    ,
    isOdd{

        @Override
        public CharSequence safeApply(Number value, Options options) {
            return !this.isEven(value) ? (CharSequence)options.param(0, "odd") : null;
        }
    }
    ,
    stripes{

        @Override
        public CharSequence safeApply(Number value, Options options) {
            return this.isEven(value) ? (CharSequence)options.param(0, "even") : (CharSequence)options.param(1, "odd");
        }
    };


    @Override
    public Object apply(Object context, Options options) throws IOException {
        if (context instanceof Number) {
            return this.safeApply((Number)context, options);
        }
        return null;
    }

    protected abstract CharSequence safeApply(Number var1, Options var2);

    protected boolean isEven(Number value) {
        return value.intValue() % 2 == 0;
    }

    public void registerHelper(Handlebars handlebars) {
        Validate.notNull(handlebars, "The handlebars is required.", new Object[0]);
        handlebars.registerHelper(this.name(), (Helper)this);
    }

    public static void register(Handlebars handlebars) {
        NumberHelper[] helpers;
        Validate.notNull(handlebars, "A handlebars object is required.", new Object[0]);
        for (NumberHelper helper : helpers = NumberHelper.values()) {
            helper.registerHelper(handlebars);
        }
    }
}

