/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.incubator.semconv.db;

import io.opentelemetry.javaagent.shaded.instrumentation.api.incubator.semconv.db.DbClientAttributesGetter;
import io.opentelemetry.javaagent.shaded.instrumentation.api.incubator.semconv.db.MultiQuery;
import io.opentelemetry.javaagent.shaded.instrumentation.api.incubator.semconv.db.SqlClientAttributesGetter;
import io.opentelemetry.javaagent.shaded.instrumentation.api.incubator.semconv.db.SqlStatementInfo;
import io.opentelemetry.javaagent.shaded.instrumentation.api.incubator.semconv.db.SqlStatementSanitizerUtil;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.SpanNameExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.SemconvStability;
import java.util.Collection;
import javax.annotation.Nullable;

public abstract class DbClientSpanNameExtractor<REQUEST>
implements SpanNameExtractor<REQUEST> {
    private static final String DEFAULT_SPAN_NAME = "DB Query";

    public static <REQUEST> SpanNameExtractor<REQUEST> create(DbClientAttributesGetter<REQUEST, ?> getter) {
        return new GenericDbClientSpanNameExtractor(getter);
    }

    public static <REQUEST> SpanNameExtractor<REQUEST> create(SqlClientAttributesGetter<REQUEST, ?> getter) {
        return new SqlClientSpanNameExtractor(getter);
    }

    private DbClientSpanNameExtractor() {
    }

    protected String computeSpanName(@Nullable String namespace, @Nullable String operationName, @Nullable String collectionName, @Nullable String storedProcedureName) {
        String mainIdentifier;
        if (operationName == null) {
            return namespace == null ? DEFAULT_SPAN_NAME : namespace;
        }
        StringBuilder spanName = new StringBuilder(operationName);
        String string = mainIdentifier = collectionName != null ? collectionName : storedProcedureName;
        if (namespace != null || mainIdentifier != null) {
            spanName.append(' ');
        }
        if (namespace != null && (mainIdentifier == null || mainIdentifier.indexOf(46) == -1)) {
            spanName.append(namespace);
            if (mainIdentifier != null) {
                spanName.append('.');
            }
        }
        if (mainIdentifier != null) {
            spanName.append(mainIdentifier);
        }
        return spanName.toString();
    }

    protected String computeSpanNameStable(DbClientAttributesGetter<REQUEST, ?> getter, REQUEST request, @Nullable String operation, @Nullable String collectionName, @Nullable String storedProcedureName) {
        String serverAddress;
        String target = collectionName;
        if (target == null) {
            target = storedProcedureName;
        }
        if (target == null) {
            target = getter.getDbNamespace(request);
        }
        if (target == null && (serverAddress = getter.getServerAddress(request)) != null) {
            Integer serverPort = getter.getServerPort(request);
            target = serverPort != null ? serverAddress + ":" + serverPort : serverAddress;
        }
        if (operation != null) {
            if (target != null) {
                return operation + " " + target;
            }
            return operation;
        }
        if (target != null) {
            return target;
        }
        String dbSystem = getter.getDbSystemName(request);
        return dbSystem != null ? dbSystem : DEFAULT_SPAN_NAME;
    }

    private static final class GenericDbClientSpanNameExtractor<REQUEST>
    extends DbClientSpanNameExtractor<REQUEST> {
        private final DbClientAttributesGetter<REQUEST, ?> getter;

        private GenericDbClientSpanNameExtractor(DbClientAttributesGetter<REQUEST, ?> getter) {
            this.getter = getter;
        }

        @Override
        public String extract(REQUEST request) {
            String namespace = this.getter.getDbNamespace(request);
            String operationName = this.getter.getDbOperationName(request);
            if (SemconvStability.emitStableDatabaseSemconv()) {
                return this.computeSpanNameStable(this.getter, request, operationName, null, null);
            }
            return this.computeSpanName(namespace, operationName, null, null);
        }
    }

    private static final class SqlClientSpanNameExtractor<REQUEST>
    extends DbClientSpanNameExtractor<REQUEST> {
        private final SqlClientAttributesGetter<REQUEST, ?> getter;

        private SqlClientSpanNameExtractor(SqlClientAttributesGetter<REQUEST, ?> getter) {
            this.getter = getter;
        }

        @Override
        public String extract(REQUEST request) {
            String namespace = this.getter.getDbNamespace(request);
            Collection<String> rawQueryTexts = this.getter.getRawQueryTexts(request);
            if (rawQueryTexts.isEmpty()) {
                if (SemconvStability.emitStableDatabaseSemconv()) {
                    return this.computeSpanNameStable(this.getter, request, null, null, null);
                }
                return this.computeSpanName(namespace, null, null, null);
            }
            if (!SemconvStability.emitStableDatabaseSemconv()) {
                if (rawQueryTexts.size() > 1) {
                    return this.computeSpanName(namespace, null, null, null);
                }
                SqlStatementInfo sanitizedStatement = SqlStatementSanitizerUtil.sanitize(rawQueryTexts.iterator().next());
                return this.computeSpanName(namespace, sanitizedStatement.getOperationName(), sanitizedStatement.getCollectionName(), sanitizedStatement.getStoredProcedureName());
            }
            if (rawQueryTexts.size() == 1) {
                SqlStatementInfo sanitizedStatement = SqlStatementSanitizerUtil.sanitize(rawQueryTexts.iterator().next());
                String operationName = sanitizedStatement.getOperationName();
                if (this.isBatch(request)) {
                    operationName = operationName == null ? "BATCH" : "BATCH " + operationName;
                }
                return this.computeSpanNameStable(this.getter, request, operationName, sanitizedStatement.getCollectionName(), sanitizedStatement.getStoredProcedureName());
            }
            MultiQuery multiQuery = MultiQuery.analyze(rawQueryTexts, false);
            return this.computeSpanNameStable(this.getter, request, multiQuery.getOperationName(), multiQuery.getCollectionName(), multiQuery.getStoredProcedureName());
        }

        private boolean isBatch(REQUEST request) {
            Long batchSize = this.getter.getDbOperationBatchSize(request);
            return batchSize != null && batchSize > 1L;
        }
    }
}

