/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.incubator.semconv.db;

import io.opentelemetry.javaagent.shaded.instrumentation.api.incubator.semconv.db.DbClientAttributesExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.incubator.semconv.db.MultiQuery;
import io.opentelemetry.javaagent.shaded.instrumentation.api.incubator.semconv.db.SqlClientAttributesExtractorBuilder;
import io.opentelemetry.javaagent.shaded.instrumentation.api.incubator.semconv.db.SqlClientAttributesGetter;
import io.opentelemetry.javaagent.shaded.instrumentation.api.incubator.semconv.db.SqlStatementInfo;
import io.opentelemetry.javaagent.shaded.instrumentation.api.incubator.semconv.db.SqlStatementSanitizerUtil;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.AttributesExtractorUtil;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.SemconvStability;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.SpanKey;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.SpanKeyProvider;
import io.opentelemetry.javaagent.shaded.instrumentation.api.semconv.network.ServerAttributesExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.semconv.network.internal.InternalNetworkAttributesExtractor;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Context;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.semconv.AttributeKeyTemplate;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.semconv.DbAttributes;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nullable;

public final class SqlClientAttributesExtractor<REQUEST, RESPONSE>
implements AttributesExtractor<REQUEST, RESPONSE>,
SpanKeyProvider {
    private static final AttributeKey<String> DB_OPERATION = AttributeKey.stringKey("db.operation");
    private static final AttributeKey<String> DB_STATEMENT = AttributeKey.stringKey("db.statement");
    private static final AttributeKeyTemplate<String> DB_QUERY_PARAMETER = AttributeKeyTemplate.stringKeyTemplate("db.query.parameter");
    private static final String SQL_CALL = "CALL";
    private final SqlClientAttributesGetter<REQUEST, RESPONSE> getter;
    private final InternalNetworkAttributesExtractor<REQUEST, RESPONSE> internalNetworkExtractor;
    private final ServerAttributesExtractor<REQUEST, RESPONSE> serverAttributesExtractor;
    private final AttributeKey<String> oldSemconvTableAttribute;
    private final boolean statementSanitizationEnabled;
    private final boolean captureQueryParameters;

    public static <REQUEST, RESPONSE> AttributesExtractor<REQUEST, RESPONSE> create(SqlClientAttributesGetter<REQUEST, RESPONSE> getter) {
        return SqlClientAttributesExtractor.builder(getter).build();
    }

    public static <REQUEST, RESPONSE> SqlClientAttributesExtractorBuilder<REQUEST, RESPONSE> builder(SqlClientAttributesGetter<REQUEST, RESPONSE> getter) {
        return new SqlClientAttributesExtractorBuilder<REQUEST, RESPONSE>(getter);
    }

    SqlClientAttributesExtractor(SqlClientAttributesGetter<REQUEST, RESPONSE> getter, AttributeKey<String> oldSemconvTableAttribute, boolean statementSanitizationEnabled, boolean captureQueryParameters) {
        this.getter = getter;
        this.oldSemconvTableAttribute = oldSemconvTableAttribute;
        this.statementSanitizationEnabled = !captureQueryParameters && statementSanitizationEnabled;
        this.captureQueryParameters = captureQueryParameters;
        this.internalNetworkExtractor = new InternalNetworkAttributesExtractor<REQUEST, RESPONSE>(getter, true, false);
        this.serverAttributesExtractor = ServerAttributesExtractor.create(getter);
    }

    @Override
    public void onStart(AttributesBuilder attributes, Context parentContext, REQUEST request) {
        String operation;
        SqlStatementInfo sanitizedStatement;
        String rawQueryText;
        boolean isBatch;
        Collection<String> rawQueryTexts = this.getter.getRawQueryTexts(request);
        Long batchSize = this.getter.getBatchSize(request);
        boolean bl = isBatch = batchSize != null && batchSize > 1L;
        if (SemconvStability.emitOldDatabaseSemconv() && rawQueryTexts.size() == 1) {
            rawQueryText = rawQueryTexts.iterator().next();
            sanitizedStatement = SqlStatementSanitizerUtil.sanitize(rawQueryText);
            operation = sanitizedStatement.getOperation();
            AttributesExtractorUtil.internalSet(attributes, DB_STATEMENT, this.statementSanitizationEnabled ? sanitizedStatement.getFullStatement() : rawQueryText);
            AttributesExtractorUtil.internalSet(attributes, DB_OPERATION, operation);
            if (!SQL_CALL.equals(operation)) {
                AttributesExtractorUtil.internalSet(attributes, this.oldSemconvTableAttribute, sanitizedStatement.getMainIdentifier());
            }
        }
        if (SemconvStability.emitStableDatabaseSemconv()) {
            if (isBatch) {
                AttributesExtractorUtil.internalSet(attributes, DbAttributes.DB_OPERATION_BATCH_SIZE, batchSize);
            }
            if (rawQueryTexts.size() == 1) {
                rawQueryText = rawQueryTexts.iterator().next();
                sanitizedStatement = SqlStatementSanitizerUtil.sanitize(rawQueryText);
                operation = sanitizedStatement.getOperation();
                AttributesExtractorUtil.internalSet(attributes, DbAttributes.DB_QUERY_TEXT, this.statementSanitizationEnabled ? sanitizedStatement.getFullStatement() : rawQueryText);
                AttributesExtractorUtil.internalSet(attributes, DbAttributes.DB_OPERATION_NAME, isBatch ? "BATCH " + operation : operation);
                if (!SQL_CALL.equals(operation)) {
                    AttributesExtractorUtil.internalSet(attributes, DbAttributes.DB_COLLECTION_NAME, sanitizedStatement.getMainIdentifier());
                }
            } else if (rawQueryTexts.size() > 1) {
                MultiQuery multiQuery = MultiQuery.analyze(this.getter.getRawQueryTexts(request), this.statementSanitizationEnabled);
                AttributesExtractorUtil.internalSet(attributes, DbAttributes.DB_QUERY_TEXT, SqlClientAttributesExtractor.join("; ", multiQuery.getStatements()));
                String operation2 = multiQuery.getOperation() != null ? "BATCH " + multiQuery.getOperation() : "BATCH";
                AttributesExtractorUtil.internalSet(attributes, DbAttributes.DB_OPERATION_NAME, operation2);
                if (!(multiQuery.getMainIdentifier() == null || multiQuery.getOperation() != null && SQL_CALL.equals(multiQuery.getOperation()))) {
                    AttributesExtractorUtil.internalSet(attributes, DbAttributes.DB_COLLECTION_NAME, multiQuery.getMainIdentifier());
                }
            }
        }
        Map<String, String> queryParameters = this.getter.getQueryParameters(request);
        this.setQueryParameters(attributes, isBatch, queryParameters);
        DbClientAttributesExtractor.onStartCommon(attributes, this.getter, request);
        this.serverAttributesExtractor.onStart(attributes, parentContext, request);
    }

    private void setQueryParameters(AttributesBuilder attributes, boolean isBatch, Map<String, String> queryParameters) {
        if (this.captureQueryParameters && !isBatch && queryParameters != null) {
            for (Map.Entry<String, String> entry : queryParameters.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                AttributesExtractorUtil.internalSet(attributes, DB_QUERY_PARAMETER.getAttributeKey(key), value);
            }
        }
    }

    private static String join(String delimiter, Collection<String> collection) {
        StringBuilder builder = new StringBuilder();
        for (String string : collection) {
            if (builder.length() != 0) {
                builder.append(delimiter);
            }
            builder.append(string);
        }
        return builder.toString();
    }

    @Override
    public void onEnd(AttributesBuilder attributes, Context context, REQUEST request, @Nullable RESPONSE response, @Nullable Throwable error) {
        this.internalNetworkExtractor.onEnd(attributes, request, response);
        DbClientAttributesExtractor.onEndCommon(attributes, this.getter, response, error);
    }

    @Override
    public SpanKey internalGetSpanKey() {
        return SpanKey.DB_CLIENT;
    }
}

