/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.bootstrap;

import java.security.ProtectionDomain;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;

public final class InjectedClassHelper {
    private static volatile BiPredicate<ClassLoader, String> helperClassDetector;
    private static volatile BiFunction<ClassLoader, String, HelperClassInfo> helperClassInfo;

    private InjectedClassHelper() {
    }

    public static void internalSetHelperClassDetector(BiPredicate<ClassLoader, String> helperClassDetector) {
        if (InjectedClassHelper.helperClassDetector != null) {
            return;
        }
        InjectedClassHelper.helperClassDetector = helperClassDetector;
    }

    public static boolean isHelperClass(Class<?> clazz) {
        return InjectedClassHelper.isHelperClass(clazz.getClassLoader(), clazz.getName());
    }

    public static boolean isHelperClass(ClassLoader classLoader, String className) {
        if (helperClassDetector == null) {
            return false;
        }
        return helperClassDetector.test(classLoader, className);
    }

    public static void internalSetHelperClassInfo(BiFunction<ClassLoader, String, HelperClassInfo> helperClassInfo) {
        if (InjectedClassHelper.helperClassInfo != null) {
            return;
        }
        InjectedClassHelper.helperClassInfo = helperClassInfo;
    }

    public static HelperClassInfo getHelperClassInfo(ClassLoader classLoader, String className) {
        if (helperClassInfo == null) {
            return null;
        }
        return helperClassInfo.apply(classLoader, className);
    }

    public static interface HelperClassInfo {
        public byte[] getClassBytes();

        public ProtectionDomain getProtectionDomain();
    }
}

