/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.http;

import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.Attributes;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.semconv.trace.attributes.SemanticAttributes;
import java.util.HashSet;
import java.util.Set;

final class TemporaryMetricsView {
    private static final Set<AttributeKey> durationAlwaysInclude = TemporaryMetricsView.buildDurationAlwaysInclude();
    private static final Set<AttributeKey> durationClientView = TemporaryMetricsView.buildDurationClientView();
    private static final Set<AttributeKey> durationServerView = TemporaryMetricsView.buildDurationServerView();
    private static final Set<AttributeKey> durationServerFallbackView = TemporaryMetricsView.buildDurationServerFallbackView();
    private static final Set<AttributeKey> activeRequestsView = TemporaryMetricsView.buildActiveRequestsView();

    private static Set<AttributeKey> buildDurationAlwaysInclude() {
        HashSet<AttributeKey> view = new HashSet<AttributeKey>();
        view.add(SemanticAttributes.HTTP_METHOD);
        view.add(SemanticAttributes.HTTP_STATUS_CODE);
        view.add(SemanticAttributes.HTTP_FLAVOR);
        return view;
    }

    private static Set<AttributeKey> buildDurationClientView() {
        HashSet<AttributeKey> view = new HashSet<AttributeKey>(durationAlwaysInclude);
        view.add(SemanticAttributes.HTTP_URL);
        return view;
    }

    private static Set<AttributeKey> buildDurationServerView() {
        HashSet<AttributeKey> view = new HashSet<AttributeKey>(durationAlwaysInclude);
        view.add(SemanticAttributes.HTTP_SCHEME);
        view.add(SemanticAttributes.HTTP_HOST);
        view.add(SemanticAttributes.HTTP_ROUTE);
        return view;
    }

    private static Set<AttributeKey> buildDurationServerFallbackView() {
        HashSet<AttributeKey> view = new HashSet<AttributeKey>(durationAlwaysInclude);
        view.add(SemanticAttributes.HTTP_SCHEME);
        view.add(SemanticAttributes.HTTP_HOST);
        view.add(SemanticAttributes.HTTP_TARGET);
        return view;
    }

    private static Set<AttributeKey> buildActiveRequestsView() {
        HashSet<AttributeKey> view = new HashSet<AttributeKey>();
        view.add(SemanticAttributes.HTTP_METHOD);
        view.add(SemanticAttributes.HTTP_HOST);
        view.add(SemanticAttributes.HTTP_SCHEME);
        view.add(SemanticAttributes.HTTP_FLAVOR);
        view.add(SemanticAttributes.HTTP_SERVER_NAME);
        return view;
    }

    static Attributes applyClientDurationView(Attributes startAttributes, Attributes endAttributes) {
        AttributesBuilder filtered = Attributes.builder();
        TemporaryMetricsView.applyView(filtered, startAttributes, durationClientView);
        TemporaryMetricsView.applyView(filtered, endAttributes, durationClientView);
        return filtered.build();
    }

    private static <T> boolean containsAttribute(AttributeKey<T> key, Attributes startAttributes, Attributes endAttributes) {
        return startAttributes.get(key) != null || endAttributes.get(key) != null;
    }

    static Attributes applyServerDurationView(Attributes startAttributes, Attributes endAttributes) {
        Set<AttributeKey> fullSet = durationServerView;
        if (!TemporaryMetricsView.containsAttribute(SemanticAttributes.HTTP_ROUTE, startAttributes, endAttributes)) {
            fullSet = durationServerFallbackView;
        }
        AttributesBuilder filtered = Attributes.builder();
        TemporaryMetricsView.applyView(filtered, startAttributes, fullSet);
        TemporaryMetricsView.applyView(filtered, endAttributes, fullSet);
        return filtered.build();
    }

    static Attributes applyActiveRequestsView(Attributes attributes) {
        AttributesBuilder filtered = Attributes.builder();
        TemporaryMetricsView.applyView(filtered, attributes, activeRequestsView);
        return filtered.build();
    }

    private static void applyView(AttributesBuilder filtered, Attributes attributes, Set<AttributeKey> view) {
        attributes.forEach((key, value) -> {
            if (view.contains(key)) {
                if (SemanticAttributes.HTTP_URL.equals(key) || SemanticAttributes.HTTP_TARGET.equals(key)) {
                    filtered.put(key, TemporaryMetricsView.removeQueryParamFromUrlOrTarget(value.toString()));
                } else {
                    filtered.put(key, value);
                }
            }
        });
    }

    private static String removeQueryParamFromUrlOrTarget(String urlOrTarget) {
        int idx = -1;
        for (int i = 0; i < urlOrTarget.length(); ++i) {
            char ch = urlOrTarget.charAt(i);
            if (ch != '?' && ch != ';') continue;
            idx = i;
            break;
        }
        return idx == -1 ? urlOrTarget : urlOrTarget.substring(0, idx);
    }

    private TemporaryMetricsView() {
    }
}

